# Filters devices directory moving folders on uninstalled devices to ../uninstalled_devices directory
New-Item ..\uninstalled_devices -itemtype directory
$devices = Get-ChildItem | where-object{$_.Name.StartsWith('x')} 
$devices | ForEach-Object {
	$subvendor = $_.Name.substring(1,4)
	$subdevice = $_.Name.Substring(6,4)
	$name=$_.Name
	$device = Get-PnpDevice | where-object{($_.InstanceID.Contains($subdevice)) -and ($_.InstanceID.Contains($subvendor))}
	if ($device.count -eq 0){
		Move-Item .\$name ..\uninstalled_devices\$name
	} 
}
