﻿<?xml version="1.0"?>
<instrumentationManifest xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd" xmlns="http://schemas.microsoft.com/win/2004/08/events" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:trace="http://schemas.microsoft.com/win/2004/08/events/trace">
	<instrumentation>
		<counters schemaVersion="1.1" xmlns="http://schemas.microsoft.com/win/2005/12/counters">
			<provider providerName="Mlx5Provider" providerGuid="{16831217-C60E-4255-87B3-3AF46BD095C0}" applicationIdentity="Mlx5.sys" resourceBase="1" providerType="kernelMode" callback="custom">
				<counterSet name="Mellanox WinOF-2 Port Traffic" symbol="TrafficCounters" guid="{66F34001-AEB6-47ED-97A1-FC6AFE721A19}" uri="Mlx5.TrafficCounters" description="This set contains traffic counters" instances="multipleAggregate">
					<structs>
						<struct name="TrafficCounterStruct" type="traffic_counters"></struct>
					</structs>
					<counter name="Bytes Received" uri="Mlx5.TrafficCounters.Bytes_Received" description="Shows the number of bytes received by network adapter. The counted bytes include framing characters." id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64BytesReceived"></counter>
					<counter name="KBytes Received/Sec" uri="Mlx5.TrafficCounters.KBytes_Received_Sec" description="Shows the rate at which kilobytes are received by network adapter. The counted kilobytes include framing characters." id="1" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64KBytesReceivedSec"></counter>
					<counter name="Packets Received" uri="Mlx5.TrafficCounters.Packets_Received" description="Shows the number of packets received by network interface." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceived"></counter>
					<counter name="Packets Received/Sec" uri="Mlx5.TrafficCounters.Packets_Received_Sec" description="Shows the rate at which packets are received by network interface." id="3" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedSec"></counter>
					<counter name="Bytes Sent" uri="Mlx5.TrafficCounters.Bytes_Sent" description="Shows the number of bytes sent by network adapter. The counted bytes include framing characters." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64BytesSent"></counter>
					<counter name="KBytes Sent/Sec" uri="Mlx5.TrafficCounters.KBytes_Sent_Sec" description="Shows the rate at which kilobytes are sent by network adapter. The counted kilobytes include framing characters." id="5" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64KBytesSentSec"></counter>
					<counter name="Packets Sent" uri="Mlx5.TrafficCounters.Packets_Sent" description="Shows the number of packets sent by network interface." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsSent"></counter>
					<counter name="Packets Sent/Sec" uri="Mlx5.TrafficCounters.Packets_Sent_Sec" description="Shows the rate at which packets are sent by network interface." id="7" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsSentSec"></counter>
					<counter name="Bytes Total" uri="Mlx5.TrafficCounters.Bytes_Total" description="Shows the total of bytes handled by network adapter. The counted bytes include framing characters." id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64BytesTotal"></counter>
					<counter name="KBytes Total/Sec" uri="Mlx5.TrafficCounters.KBytes_Total_Sec" description="Shows the total rate of kilobytes that are sent and received by network adapter. The counted kilobytes include framing characters." id="9" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64KBytesTotalSec"></counter>
					<counter name="Packets Total" uri="Mlx5.TrafficCounters.Packets_Total" description="Shows the total of packets handled by network interface." id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsTotal"></counter>
					<counter name="Packets Total/Sec" uri="Mlx5.TrafficCounters.Packets_Total_Sec" description="Shows the rate at which packets are sent and received by network interface." id="11" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsTotalSec"></counter>
					<counter name="Control Packets" uri="Mlx5.TrafficCounters.Control_Packets" description="The total number of successfully received control frames." id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64ControlPackets"></counter>
					<counter name="Packets Outbound Errors" uri="Mlx5.TrafficCounters.Packets_Outbound_Errors" description="Shows the number of outbound packets that could not be transmitted because of errors found in the physical layer." id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsOutboundErrors"></counter>
					<counter name="Packets Outbound Discarded" uri="Mlx5.TrafficCounters.Packets_Outbound_Discarded" description="Shows the number of outbound packets to be discarded in the physical layer, even though no errors had been detected to prevent transmission. One possible reason for discarding packets could be to free up buffer space." id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsOutboundDiscarded"></counter>
					<counter name="Packets Received Errors" uri="Mlx5.TrafficCounters.Packets_Received_Errors" description="Shows the number of inbound packets that contained errors in the physical layer, preventing them from being deliverable." id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedErrors"></counter>
					<counter name="Packets Received Frame Length Error" uri="Mlx5.TrafficCounters.Packets_Received_Frame_Length_Error" description="Shows the number of inbound packets that contained error where the frame has length error. Packets received with frame length error are a subset of packets received errors." id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedFrameLengthError"></counter>
					<counter name="Packets Received Symbol Error" uri="Mlx5.TrafficCounters.Packets_Received_Symbol_Error" description="Shows the number of inbound packets that contained symbol error or an invalid block. Packets received with symbol error are a subset of packets received errors." id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedSymbolError"></counter>
					<counter name="Packets Received Bad CRC Error" uri="Mlx5.TrafficCounters.Packets_Received_Bad_CRC_Error" description="Shows the number of inbound packets that contained bad CRC error. Packets received with bad CRC error are a subset of packets received errors." id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedBadCRCError"></counter>
					<counter name="Packets Received Discarded - No Receive WQEs" uri="Mlx5.TrafficCounters.Packets_Received_Discarded_No_Recv_WQEs" description="Packets discarded due to no receive descriptors posted by driver or software." id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedDiscardedNoRecvWQEs"></counter>
					<counter name="RSC Aborts" uri="Mlx5.TrafficCounters.Rsc_Aborts" description="Number of RSC abort events. That is, the number of exceptions other than the IP datagram length being exceeded. This includes the cases where a packet is not coalesced because of insufficient hardware resources." id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscAborts"></counter>
					<counter name="RSC Coalesced Events" uri="Mlx5.TrafficCounters.Rsc_Coalesced_Events" description="Number of RSC Coalesced events. That is, the total number of packets that were formed from coalescing packets." id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscCoalescedEvents"></counter>
					<counter name="RSC Coalesced Octets" uri="Mlx5.TrafficCounters.Rsc_Coalesced_Octets" description="Number of RSC Coalesced bytes." id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscCoalescedOctets"></counter>
					<counter name="RSC Coalesced Packets" uri="Mlx5.TrafficCounters.Rsc_Coalesced_Packets" description="Number of RSC Coalesced Packets." id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscCoalescedPackets"></counter>
					<counter name="RSC Average Packet Size" uri="Mlx5.TrafficCounters.RSC_Average_Packet_Size" description="RSC Average Packet Size is the average size in bytes of received packets across all TCP connections." id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscAveragePacketSize"></counter>
					<counter name="Packets Received Frame Too Long Error" uri="Mlx5.TrafficCounters.Packets_Received_Frame_too_long_Error" description="The number of received packets on a physical port dropped due to a large MTU size." id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedDiscardedtooLong"></counter>
					<counter name="Packets Received Unsupported Opcode Error" uri="Mlx5.TrafficCounters.Packets_Received_unsupported_opcode_error" description="The number of MAC control packets received on a physical port with unsupported opcode." id="26" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedDiscardedUnsupportedOpcode"></counter>
					<counter name="Packets Received Frame Undersize Error" uri="Mlx5.TrafficCounters.Packets_Received_Frame_undersize_error" description="The number of received packets on a physical port dropped due to the length of the packet being shorter than 64 bytes." id="27" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedDiscardedUnderSize"></counter>
					<counter name="Packets Received Fragments Error" uri="Mlx5.TrafficCounters.Packets_Received_fragments_Error" description="The number of received packets on a physical port dropped due to the length of the packet being shorter than 64 bytes and have FCS error." id="28" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedDiscardedFragments"></counter>
					<counter name="Packets Received Jabbers Error" uri="Mlx5.TrafficCounters.Packets_Received_jabbers_Error" description="The number of received packets on a physical port dropped due to the length of the packet being longer than 64 bytes and have FCS error." id="29" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedDiscardedJabbers"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Port QoS" symbol="QoSCounters" guid="{9EFE5F1D-D787-4B49-9D80-8E59D65A30AE}" uri="Mlx5.QoSCounters" description="This set contains QoS counters" instances="multipleAggregate">
					<structs>
						<struct name="QoSCounterStruct" type="QoS_counters"></struct>
					</structs>
					<counter name="Bytes Received" uri="Mlx5.QoSCounters.Bytes_Received" description="The number of bytes received that are covered by this priority. The counted bytes include framing characters." id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64BytesReceived"></counter>
					<counter name="KBytes Received/Sec" uri="Mlx5.QoSCounters.KBytes_Received_Sec" description="The number of kilobytes received per second that are covered by this priority. The counted kilobytes include framing characters." id="1" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64KBytesReceivedSec"></counter>
					<counter name="Packets Received" uri="Mlx5.QoSCounters.Packets_Received" description="The number of packets received that are covered by this priority." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsReceived"></counter>
					<counter name="Packets Received/Sec" uri="Mlx5.QoSCounters.Packets_Received_Sec" description="The number of packets received per second that are covered by this priority." id="3" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsReceivedSec"></counter>
					<counter name="Bytes Sent" uri="Mlx5.QoSCounters.Bytes_Sent" description="The number of bytes sent that are covered by this priority. The counted bytes include framing characters." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64BytesSent"></counter>
					<counter name="KBytes Sent/Sec" uri="Mlx5.QoSCounters.KBytes_Sent_Sec" description="The number of kilobytes sent per second that are covered by this priority. The counted kilobytes include framing characters." id="5" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64KBytesSentSec"></counter>
					<counter name="Packets Sent" uri="Mlx5.QoSCounters.Packets_Sent" description="The number of packets sent that are covered by this priority." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsSent"></counter>
					<counter name="Packets Sent/Sec" uri="Mlx5.QoSCounters.Packets_Sent_Sec" description="The number of packets sent per second that are covered by this priority." id="7" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsSentSec"></counter>
					<counter name="Bytes Total" uri="Mlx5.QoSCounters.Bytes_Total" description="The total number of bytes that are covered by this priority. The counted bytes include framing characters." id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64BytesTotal"></counter>
					<counter name="KBytes Total/Sec" uri="Mlx5.QoSCounters.KBytes_Total_Sec" description="The total number of kilobytes per second that are covered by this priority. The counted kilobytes include framing characters." id="9" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64KBytesTotalSec"></counter>
					<counter name="Packets Total" uri="Mlx5.QoSCounters.Packets_Total" description="The total number of packets that are covered by this priority." id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsTotal"></counter>
					<counter name="Packets Total/Sec" uri="Mlx5.QoSCounters.Packets_Total_Sec" description="The total number of packets per second that are covered by this priority." id="11" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsTotalSec"></counter>
					<counter name="Sent Pause Frames" uri="Mlx5.QoSCounters.Sent_Pause_Frames" description="The number of pause frames that were sent to this priority. The untagged instance indicates global pause frames that were sent." id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64SentPauseFrames"></counter>
					<counter name="Sent Pause Duration" uri="Mlx5.QoSCounters.Sent_Pause_Duration" description="The total duration in microseconds that transmission of packets has been paused on this priority." id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64SentPauseDuration"></counter>
					<counter name="Rcv Pause Frames" uri="Mlx5.QoSCounters.Rcv_Pause_Frames" description="The number of pause frames that were received for this priority. The untagged instance indicates global pause frames that were received." id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64RcvPauseFrames"></counter>
					<counter name="Rcv Pause Duration" uri="Mlx5.QoSCounters.Rcv_Pause_Duration" description="The total duration in microseconds of pause that was requested by the other end to freeze transmission on this priority." id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64RcvPauseDuration"></counter>
					<counter name="packets received discarded" uri="Mlx5.QoSCounters.packets_received_discarded " description="The number of received packets to be discarded in the physical layer even though no errors have been detected to prevent transmission. A possible reason for discarding packets could be to free up buffer space." id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64RxDiscards"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 VF Port Traffic" symbol="VPortTrafficCounters" guid="{f6375299-ed2e-4abb-ad01-3f658f29ea27}" uri="Mlx5.VPortTrafficCounters" description="This set contains VPort traffic counters" instances="multipleAggregate">
					<structs>
						<struct name="VPortTrafficCounterStruct" type="PerfmonVportTrafficCounters"></struct>
					</structs>
					<counter name="Bytes Received/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Sec" description="Shows the rate at which bytes are received over each network VPort. The counted bytes include framing characters." id="0" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInOctets"></counter>
					<counter name="Bytes Sent/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Sec" description="Shows the rate at which bytes are sent over each network VPort. The counted bytes include framing characters." id="1" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutOctets"></counter>
					<counter name="Packets Outbound Discarded" uri="Mlx5.VPortTrafficCounters.Packets_Outbound_Discarded" description="Shows the number of outbound packets to be discarded even though no errors had been detected to prevent transmission. One possible reason for discarding a packet could be to free up buffer space." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifOutDiscards"></counter>
					<counter name="Packets Outbound Errors" uri="Mlx5.VPortTrafficCounters.Packets_Outbound_Errors" description="Shows the number of outbound packets that could not be transmitted because of errors." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifOutErrors"></counter>
					<counter name="Packets Received Discarded" uri="Mlx5.VPortTrafficCounters.Packets_Received_Discarded" description="Shows the number of inbound packets that were chosen to be discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol. One possible reason for discarding such a packet could be to free up buffer space." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifInDiscards"></counter>
					<counter name="Packets Received Errors" uri="Mlx5.VPortTrafficCounters.Packets_Received_Errors" description="Shows the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifInErrors"></counter>
					<counter name="Packets Received Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Received_Unicast_Sec" description="Shows the rate at which subnet-unicast packets are delivered to a higher-layer protocol." id="6" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInUcastPkts"></counter>
					<counter name="Packets Received Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Received_Broadcast_Sec" description="Shows the rate at which subnet-broadcast packets are delivered to a higher-layer protocol." id="7" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInBroadcastPkts"></counter>
					<counter name="Packets Received Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Received_Multicast_Sec" description="Shows the rate at which subnet-multicast packets are delivered to a higher-layer protocol." id="8" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInMulticastPkts"></counter>
					<counter name="Packets Sent Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Sent_Unicast_Sec" description="Shows the rate at which packets are requested to be transmitted to subnet-unicast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="9" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutUcastPkts"></counter>
					<counter name="Packets Sent Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Sent_Broadcast_Sec" description="Shows the rate at which packets are requested to be transmitted to subnet-broadcast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="10" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutBroadcastPkts"></counter>
					<counter name="Packets Sent Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Sent_Multicast_Sec" description="Shows the rate at which packets are requested to be transmitted to subnet-multicast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="11" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutMulticastPkts"></counter>
					<counter name="Bytes Received Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Unicast_Sec" description="Shows the rate at which subnet-unicast bytes are delivered to a higher-layer protocol." id="12" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInUcastOctets"></counter>
					<counter name="Bytes Received Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Broadcast_Sec" description="Shows the rate at which subnet-broadcast bytes are delivered to a higher-layer protocol." id="13" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInBroadcastOctets"></counter>
					<counter name="Bytes Received Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Multicast_Sec" description="Shows the rate at which subnet-multicast bytes are delivered to a higher-layer protocol." id="14" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInMulticastOctets"></counter>
					<counter name="Bytes Sent Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Unicast_Sec" description="Shows the rate at which bytes are requested to be transmitted to subnet-unicast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="15" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutUcastOctets"></counter>
					<counter name="Bytes Sent Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Broadcast_Sec" description="Shows the rate at which bytes are requested to be transmitted to subnet-broadcast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="16" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutBroadcastOctets"></counter>
					<counter name="Bytes Sent Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Multicast_Sec" description="Shows the rate at which bytes are requested to be transmitted to subnet-multicast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="17" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutMulticastOctets"></counter>
					<counter name="Mac Anti-Spoofing Packets Discarded" uri="Mlx5.VPortTrafficCounters.Mac_Anti_Spoofing_Packets_Dicarded" description="Shows the number of packets discarded due to illegal mac address usage." id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64MacAntiSpoofingDiscardsPackets"></counter>
					<counter name="Mac Anti-Spoofing Bytes Discarded" uri="Mlx5.VPortTrafficCounters.Mac_Anti_Spoofing_Bytes_Dicarded" description="Shows the number of bytes discarded due to illegal mac address usage." id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64MacAntiSpoofingDiscardsOctets"></counter>
					<counter name="Vlan Anti-Spoofing Packets Discarded" uri="Mlx5.VPortTrafficCounters.vlan_Anti_Spoofing_Packets_Dicarded" description="Shows the number of packets discarded due to illegal vlan usage." id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64VlanAntiSpoofingDiscardsPackets"></counter>
					<counter name="Vlan Anti-Spoofing Bytes Discarded" uri="Mlx5.VPortTrafficCounters.vlan_Anti_Spoofing_Bytes_Dicarded" description="Shows the number of bytes discarded due to illegal vlan usage." id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64VlanAntiSpoofingDiscardsOctets"></counter>
					<counter name="Allowed EthType Anti-Spoofing Packets Discarded" uri="Mlx5.VPortTrafficCounters.ethtype_Anti_Spoofing_Packets_Dicarded" description="Shows the number of packets discarded due to unallowed ether type usage." id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64EthertypeAntiSpoofingDiscardsPackets"></counter>
					<counter name="Allowed EthType Anti-Spoofing Bytes Discarded" uri="Mlx5.VPortTrafficCounters.ethtype_Anti_Spoofing_Bytes_Dicarded" description="Shows the number of Bytes discarded due to unallowed ether type usage." id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64EthertypeAntiSpoofingDiscardsOctets"></counter>
					<counter name="Rdma Packets Received Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Packets_Received_Unicast_Sec" description="Shows the rate at which subnet-unicast rdma packets are delivered to a higher-layer protocol." id="24" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaInUcastPkts"></counter>
					<counter name="Rdma Packets Received Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Packets_Received_Multicast_Sec" description="Shows the rate at which subnet-multicast rdma packets are delivered to a higher-layer protocol." id="25" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaInMulticastPkts"></counter>
					<counter name="Rdma Packets Sent Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Packets_Sent_Unicast_Sec" description="Shows the rate at which rdma packets are requested to be transmitted to subnet-unicast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="26" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaOutUcastPkts"></counter>
					<counter name="Rdma Packets Sent Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Packets_Sent_Multicast_Sec" description="Shows the rate at which rdma packets are requested to be transmitted to subnet-multicast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="27" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaOutMulticastPkts"></counter>
					<counter name="Rdma Bytes Received Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Bytes_Received_Unicast_Sec" description="Shows the rate at which subnet-unicast rdma bytes are delivered to a higher-layer protocol." id="28" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaInUcastOctets"></counter>
					<counter name="Rdma Bytes Received Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Bytes_Received_Multicast_Sec" description="Shows the rate at which subnet-multicast rdma bytes are delivered to a higher-layer protocol." id="29" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaInMulticastOctets"></counter>
					<counter name="Rdma Bytes Sent Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Bytes_Sent_Unicast_Sec" description="Shows the rate at which rdma bytes are requested to be transmitted to subnet-unicast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="30" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaOutUcastOctets"></counter>
					<counter name="Rdma Bytes Sent Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Rdma_Bytes_Sent_Multicast_Sec" description="Shows the rate at which rdma bytes are requested to be transmitted to subnet-multicast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="31" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifRdmaOutMulticastOctets"></counter>
					<counter name="RoCE Restrict Packets Discarded" uri="Mlx5.VPortTrafficCounters.roce_Restrict_Packets_Dicarded" description="Shows the number of packets discarded due to RoCE Restriction for a specific IPv6 Src address." id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64RoceRestrictDiscardsPackets"></counter>
					<counter name="RoCE Restrict Bytes Discarded" uri="Mlx5.VPortTrafficCounters.roce_Restrict_Bytes_Dicarded" description="Shows the number of Bytes discarded due to RoCE Restriction for a specific IPv6 Src address." id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="u64RoceRestrictDiscardsOctets"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Congestion Control" symbol="CongestionControlCounters" guid="{255816e0-14ec-46cd-89ea-471e09d5da4d}" uri="Mlx5.CongestionControlCounters" description="This set contains congestion control counters" instances="multipleAggregate">
					<structs>
						<struct name="CongestionControlCounterStruct" type="CongCtrlCounters"></struct>
					</structs>
					<counter name="Reaction Point - Current Number of Flows" uri="Mlx5.CongestionControlCounters.Reaction_Point_Current_Number_of_Flows" description="Current Number of Rate Limited Flows due to RoCEv2 Congestion Management." id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointCurrentNumberOfFlows"></counter>
					<counter name="Reaction Point - Ignored CNP Packets" uri="Mlx5.CongestionControlCounters.Reaction_Point_Ignored_CNP_Packets" description="The number of ignored rate limitation requests." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64ReactionPointIgnoredCNPPackets"></counter>
					<counter name="Reaction Point - Successfully Handled CNP Packets" uri="Mlx5.CongestionControlCounters.Reaction_Point_Successfully_Handled_CNP_Packets" description="The number of congestion notification packet (CNP) received and handled successfully." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64ReactionPointSuccessfullyHandledCNPPackets"></counter>
					<counter name="Notification Point - RoCEv2 ECN Marked Packets" uri="Mlx5.CongestionControlCounters.Notification_Point_RoCEv2_ECN_Marked_Packets" description="Number of RoCEv2 packets that were marked as congestion encountered." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64NotificationPointRoCEv2ECNMarkedPackets"></counter>
					<counter name="Notification Point - CNPs Sent Successfully" uri="Mlx5.CongestionControlCounters.Notification_Point_CNPs_Sent_Successfully" description="The number of congestion notification packets (CNPs) successfully sent by the notification point." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64NotificationPointCNPsSentSuccessfully"></counter>
					<counter name="Reaction Point - RTT Value in Microsec" uri="Mlx5.CongestionControlCounters.Reaction_Point_RTT_Value_in_Microsec" description="Current value of RTT in microseconds." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointRTTValueInMicrosec"></counter>
					<counter name="Reaction Point - Number of QPs Under CC Increased" uri="Mlx5.CongestionControlCounters.Reaction_Point_Number_of_QPs_Under_CC_Increased" description="The number of times number of QPs under CC was increased to cross an RTT dynamic update threshold." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointNumberOfQPsUnderCCIncreased"></counter>
					<counter name="Reaction Point - Number of QPs Under CC Decreased" uri="Mlx5.CongestionControlCounters.Reaction_Point_Number_of_QPs Under_CC_Decreased" description="The number of times number of QPs under CC was decreased to cross an RTT dynamic update threshold." id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointNumberOfQPsUnderCCDecreased"></counter>
					<counter name="Reaction Point - G Factor Value" uri="Mlx5.CongestionControlCounters.Reaction_Point_G_FactorValue " description="Current value of G factor." id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointGFactorValue"></counter>
					<counter name="Reaction Point - Number of G Factor Increased" uri="Mlx5.CongestionControlCounters.Reaction_Point_Number_of_G_Factor_Increased" description="The number of times G factor was increased due to low Inbound CNP rate." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointNumberOfGFactorIncreased"></counter>
					<counter name="Reaction Point - Number of G Factor Decreased" uri="Mlx5.CongestionControlCounters.Reaction_Point_Number_of_G_Factor_Decreased" description="The number of times G factor was decreased due to high Inbound CNP rate." id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointNumberOfGFactorDecreased"></counter>
					<counter name="Reaction Point - AI Factor Value" uri="Mlx5.CongestionControlCounters.Reaction_Point_AI_Factor_Value" description="Current value of AI rate." id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointAIFactorValue"></counter>
					<counter name="Reaction Point - Number of AI Factor Increased" uri="Mlx5.CongestionControlCounters.Reaction_Point_Number_of_AI_Factor_Increased" description="The number of times AI rate was increased due to lack of Inbound CNPs." id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointNumberOfAIFactorIncreased"></counter>
					<counter name="Reaction Point - Number of AI Factor Decreased" uri="Mlx5.CongestionControlCounters.Reaction_Point_Number_of_AI_Factor_Decreased" description="The number of times AI rate was reset due to Inbound CNPs." id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointNumberOfAIFactorDecreased"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Diagnostics" symbol="DiagnosticCounters" guid="{4107e19c-2428-461a-beb6-f5c4d619a260}" uri="Mlx5.DiagnosticCounters" description="This set contains diagnostics counters" instances="multipleAggregate">
					<structs>
						<struct name="DiagnosticCounterStruct" type="DiagCounters"></struct>
					</structs>
					<counter name="Reset Requests" uri="Mlx5.DiagnosticCounters.Reset_Requests" description="Number of resets requested by NDIS" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResetRequests"></counter>
					<counter name="Link State Change Events" uri="Mlx5.DiagnosticCounters.Link_State_Change_Events" description="Number of link status updates received from HW" id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64LinkStateChangeEvents"></counter>
					<counter name="Queued Send Packets" uri="Mlx5.DiagnosticCounters.Queued_Send_Packets" description="Number of send packets pending transmission due to HW queues overflow" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64QueuedSendPackets"></counter>
					<counter name="Send Completions in Passive/Sec" uri="Mlx5.DiagnosticCounters.Send_Completions_In_Passive_Sec" description="Number of send completion events handled in passive mode per second" id="3" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64SendCompletionsInPassiveSec"></counter>
					<counter name="Receive Completions in Passive/Sec" uri="Mlx5.DiagnosticCounters.Receive_Completions_In_Passive_Sec" description="Number of receive completion events handled in passive mode per second" id="4" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReceiveCompletionsInPassiveSec"></counter>
					<counter name="Copied Send Packets" uri="Mlx5.DiagnosticCounters.Copied_Send_Packets" description="Number of send packets that were copied in slow path" id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CopiedSendPackets"></counter>
					<counter name="Correct Checksum Packets In Slow Path" uri="Mlx5.DiagnosticCounters.Correct_Checksum_Packets_In_Slow_Path" description="Number of receive packets that required manual checksum calculation that resulted in success" id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CorrectChecksumPacketsInSlowPath"></counter>
					<counter name="Bad Checksum Packets In Slow Path" uri="Mlx5.DiagnosticCounters.Bad_Checksum_Packets_In_Slow_Path" description="Number of receive packets that required manual checksum calculation that resulted in failure" id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64BadChecksumPacketsInSlowPath"></counter>
					<counter name="Undetermined Checksum Packets In Slow Path" uri="Mlx5.DiagnosticCounters.Undetermined_Checksum_Packets_In_Slow_Path" description="Number of receive packets with undetermined checksum result" id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64UndeterminedChecksumPacketsInSlowPath"></counter>
					<counter name="Link State Change Down Events" uri="Mlx5.DiagnosticCounters.Link_State_Change_Down_Events" description="Number of events, received from HW, where the link state changed to down" id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uPhyLinkDownEvents"></counter>
					<counter name="Watch Dog Expired/Sec" uri="Mlx5.DiagnosticCounters.WatchDogExpired" description="DPC watchdog expirations per second" id="10" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64WatchDogExpired"></counter>
					<counter name="Minor Stall Watermark Reached" uri="Mlx5.DiagnosticCounters.Minor_Stall_Watermark_Reached" description="The number of times the device detected a stalled state for a period longer than device_stall_minor_watermark" id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64MinorStallWatermarkReached"></counter>
					<counter name="Critical Stall Watermark Reached" uri="Mlx5.DiagnosticCounters.Critical_Stall_Watermark_Reached" description="The number of times the port detected a stalled state for a period longer than device_stall_critical_watermark" id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CriticalStallWatermarkReached"></counter>
					<counter name="Head of Queue timeout Packet discarded" uri="Mlx5.DiagnosticCounters.Head_of_Queue_timeout_Packet_discarded" description="Number of packets discarded by the transmitter due to Head-Of-Queue Lifetime Limit timeout" id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64PacketDisDueHoqTimeOut"></counter>
					<counter name="Stalled State Packet discarded" uri="Mlx5.DiagnosticCounters.Stalled_state_Packet_discarded" description="Number of packets discarded by the transmitter due to TC in Stalled state" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64PacketDisDueTCStalledState"></counter>
					<counter name="Requester Timeout Received" uri="Mlx5.DiagnosticCounters.Requester_time_out_received" description="Number of time out received when the local machine generates outbound traffic." id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterTimeOutReceived"></counter>
					<counter name="Requester Out of Order Sequence NAK" uri="Mlx5.DiagnosticCounters.Requester_out_of_order_sequence_NAK" description="Number of Out of Sequence NAK received when the local machine generates outbound traffic, i.e. the number of times the local machine received NAKs indicating OOS on the receiving side" id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterOOOSeqNAKReceived"></counter>
					<counter name="Requester RNR NAK" uri="Mlx5.DiagnosticCounters.Requester_RNR_NAK" description="Number of RNR (Receiver Not Ready) NAKs received when the local machine generates outbound traffic" id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterRNRNAK"></counter>
					<counter name="Responder RNR NAK" uri="Mlx5.DiagnosticCounters.Responder_RNR_NAK" description="Number of RNR (Receiver Not Ready) NAKs sent when the local machine receives inbound traffic" id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResponderRNRNAK"></counter>
					<counter name="Responder Out of Order Sequence Received" uri="Mlx5.DiagnosticCounters.Responder_out_of_order_sequence_received" description="Number of Out of Sequence packet received when the local machine receives inbound traffic, i.e. the number of times the local machine received messages that are not consecutive" id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResponderOOOSeqReceived"></counter>
					<counter name="Responder Duplicate Request Received" uri="Mlx5.DiagnosticCounters.Responder_duplicate_request_received" description="Number of duplicate requests received when the local machine receives inbound traffic" id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResponderDuplicateRequestRecv"></counter>
					<counter name="Requester RNR NAK Retries Exceeded Error" uri="Mlx5.DiagnosticCounters.Requester_RNR_NAK_retries_exceeded_errors" description="Number of RNR (Receiver Not Ready) NAKs retries exceeded errors when the local machine generates outbound traffic" id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterRNRNAKRetriesExceededErr"></counter>
					<counter name="Responder Local Length Errors" uri="Mlx5.DiagnosticCounters.Responder_local_length_errors" description="Number of times responder detected local length errors" id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespLocalLengthErr"></counter>
					<counter name="Requester Local Length Errors" uri="Mlx5.DiagnosticCounters.Requester_local_length_errors" description="Number of times requester detected local length errors" id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqLocalLengthErr"></counter>
					<counter name="Responder Local QP Operation Errors" uri="Mlx5.DiagnosticCounters.Requester_local_qp_errors" description="Number of times responder detected local QP operation errors" id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespLocalQpErr"></counter>
					<counter name="Local Operation Errors" uri="Mlx5.DiagnosticCounters.Local_operation_errors" description="Number of local operation errors" id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64LocalOperationErr"></counter>
					<counter name="Responder Local Protection Errors" uri="Mlx5.DiagnosticCounters.Responder_local_protection_errors" description="Number of times responder detected memory protection error in its local memory subsystem" id="26" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespLocalProtection"></counter>
					<counter name="Requester Local Protection Errors" uri="Mlx5.DiagnosticCounters.Requester_local_protection_errors" description="Number of times requester detected memory protection error in its local memory subsystem" id="27" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqLocalProtection"></counter>
					<counter name="Responder CQEs with Error" uri="Mlx5.DiagnosticCounters.Responder_cqe_error" description="Number of times responder flow reported a completion with error" id="28" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespCqeErr"></counter>
					<counter name="Requester CQEs with Error" uri="Mlx5.DiagnosticCounters.Requester_cqe_error" description="Number of times requester flow reported a completion with error" id="29" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqCqeErr"></counter>
					<counter name="Requester Memory Window Binding Errors" uri="Mlx5.DiagnosticCounters.Requester_mem_win_bind_error" description="Number of times requester detected memory window binding error" id="30" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqMemWinBindErr"></counter>
					<counter name="Requester Bad Response" uri="Mlx5.DiagnosticCounters.Requester_bad_response" description="Number of times an unexpected transport layer opcode was returned by the responder" id="31" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqBadResponse"></counter>
					<counter name="Requester Remote Invalid Request Errors" uri="Mlx5.DiagnosticCounters.Requester_remote_invalid_request" description="Number of times requester detected remote invalid request error" id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqRemoteInvalidReq"></counter>
					<counter name="Responder Remote Invalid Request Errors" uri="Mlx5.DiagnosticCounters.Responder_remote_invalid_request" description="Number of times responder detected remote invalid request error" id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespRemoteInvalidReq"></counter>
					<counter name="Requester Remote Access Errors" uri="Mlx5.DiagnosticCounters.Requester_remote_access_errors" description="Number of times requester detected remote access error" id="34" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqRemoteAccessErr"></counter>
					<counter name="Responder Remote Access Errors" uri="Mlx5.DiagnosticCounters.Responder_remote_access_errors" description="Number of times responder detected remote access error" id="35" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespRemoteAccessErr"></counter>
					<counter name="Requester Remote Operation Errors" uri="Mlx5.DiagnosticCounters.Requester_operation_errors" description="Number of times requester detected remote operation error." id="36" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqRemoteOpErr"></counter>
					<counter name="Requester Retry Exceeded Errors" uri="Mlx5.DiagnosticCounters.Requester_retry_exceeded_errors" description="Number of times requester detected transport retries exceed error" id="37" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqTransportRetriesExceeded"></counter>
					<counter name="Received RDMA Write requests" uri="Mlx5.DiagnosticCounters.ReceivedRDMAWriteRequests" description="Number of RDMA write requests received" id="38" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RxWriteRequests"></counter>
					<counter name="Received RDMA Read requests" uri="Mlx5.DiagnosticCounters.ReceivedRDMAReadRequests" description="Number of RDMA read requests received" id="39" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RxReadRequests"></counter>
					<counter name="Implied NAK Sequence Errors" uri="Mlx5.DiagnosticCounters.ImpliedNAKSequenceErrors" description="Number of times the Requester detected an ACK with a PSN larger than the expected PSN for an RDMA READ or ATOMIC response. The QP retry limit was not exceeded" id="40" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ImpliedNakReceived"></counter>
					<counter name="CQ Overflow" uri="Mlx5.DiagnosticCounters.CqOverflow" description="Number of times a CQ attached to a Queue Pair reached overflow state" id="41" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CqOverflow"></counter>
					<counter name="Responder CQEs flushed with error" uri="Mlx5.DiagnosticCounters.RespCqeFlushError" description="Number of responder CQEs flushed with error flowing queue transition to error state" id="42" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespCqeFlushError"></counter>
					<counter name="Requester CQEs flushed with error" uri="Mlx5.DiagnosticCounters.ReqCqeFlushError" description="Number of requester CQEs flushed with error flowing queue transition to error state" id="43" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqCqeFlushError"></counter>
					<counter name="Send queues priority" uri="Mlx5.DiagnosticCounters.SendQueuePriority" description="The total number of QP/SQ priority/SL update events" id="44" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uSendQueuePriority"></counter>
					<counter name="Current queues under processor handle" uri="Mlx5.DiagnosticCounters.CurrentQUnderProcessorHandle" description="The current number of queues that are handled by the processor due to async error (e.g. retry exceeded) or due to errored cmd (e.g. 2eer_qp cmd). Value constantly greater than zero, may indicating about queues in error state." id="45" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uCurrentQUnderProcessorHandle"></counter>
					<counter name="Total queues under processor handle" uri="Mlx5.DiagnosticCounters.TotalQUnderProcessorHandle" description="The total number of queues that are handled by the processor due to async error (e.g. retry exceeded) or due to errored cmd (e.g. 2eer_qp cmd). Value greater than zero may be normal and expected (for example, sometimes queues are transited to error before closing)." id="46" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uTotalQUnderProcessorHandle"></counter>
					<counter name="Async EQ Overrun" uri="Mlx5.DiagnosticCounters.AsyncEQOverrun" description="Number of times an EQ mapped to Async events queue encountered overrun queue" id="47" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uAsyncEqOverrun"></counter>
					<counter name="Completion EQ Overrun" uri="Mlx5.DiagnosticCounters.CompletionEQOverrun" description="Number of times an EQ mapped to Completion events queue encountered overrun queue" id="48" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uCompletionEqOverrun"></counter>
					<counter name="Dropless Mode Entries" uri="Mlx5.DiagnosticCounters.DroplessModeEntries" description="The number of times entered dropless mode" id="49" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64DroplessModeEntries"></counter>
					<counter name="Dropless Mode Exits" uri="Mlx5.DiagnosticCounters.DroplessModeExits" description="The number of times exited dropless mode" id="50" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64DroplessModeExits"></counter>
					<counter name="Transmission Engine Hang Events" uri="Mlx5.DiagnosticCounters.TransmissionEngineHangEvents" description="The number of sx execution engine hang events" id="51" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64TransmissionEngineHangEvents"></counter>
					<counter name="MTT Entries Used For QP" uri="Mlx5.DiagnosticCounters.MTTEntriesUsedForQP" description="Number of Memory Translation Table (MTT) entries used for QPs." id="52" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64MTTEntriesUsedForQP"></counter>
					<counter name="MTT Entries Used For CQ" uri="Mlx5.DiagnosticCounters.MTTEntriesUsedForCQ" description="Number of Memory Translation Table (MTT) entries used for CQs." id="53" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64MTTEntriesUsedForCQ"></counter>
					<counter name="MTT Entries Used For EQ" uri="Mlx5.DiagnosticCounters.MTTEntriesUsedForEQ" description="Number of Memory Translation Table (MTT) entries used for EQs." id="54" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64MTTEntriesUsedForEQ"></counter>
					<counter name="MTT Entries Used For MR" uri="Mlx5.DiagnosticCounters.MTTEntriesUsedForMR" description="Number of Memory Translation Table (MTT) entries used for MRs." id="55" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64MTTEntriesUsedForMR"></counter>
					<counter name="CPU MEM-Pages (4K) Mapped By TPT For QP" uri="Mlx5.DiagnosticCounters.TPTMappedForQP" description="Total number of CPU memory pages (4K) mapped by TPT for QPs." id="56" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64TPTMappedForQP"></counter>
					<counter name="CPU MEM-Pages (4K) Mapped By TPT For CQ" uri="Mlx5.DiagnosticCounters.TPTMappedForCQ" description="Total number of CPU memory pages (4K) mapped by TPT for CQs." id="57" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64TPTMappedForCQ"></counter>
					<counter name="CPU MEM-Pages (4K) Mapped By TPT For EQ" uri="Mlx5.DiagnosticCounters.TPTMappedForEQ" description="Total number of CPU memory pages (4K) mapped by TPT for EQs." id="58" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64TPTMappedForEQ"></counter>
					<counter name="CPU MEM-Pages (4K) Mapped By TPT For MR" uri="Mlx5.DiagnosticCounters.TPTMappedForMR" description="Total number of CPU memory pages (4K) mapped by TPT for MRs." id="59" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64TPTMappedForMR"></counter>
					<counter name="Packets Received Steering Dropped" uri="Mlx5.DiagnosticCounters.Packets_Recieved_Steering_Dropped" description="The number of Packets received that were dropped by steering." id="60" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64PacketsReceivedSteeringDropped"></counter>
					<counter name="Requester QP Transport Retries Exceeded Errors" uri="Mlx5.DiagnosticCounters.Requester_QP_Transport_Retries_Exceeded_Errors" description="Requester number of transport retries exceeded EXT_QP_MAX_RETRY_LIMIT in EXT_QP_MAX_RETRY_PERIOD seconds" id="61" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64MaxQpRetryFreqExceeded"></counter>
					<counter name="DumpMeNow Calls" uri="Mlx5.DiagnosticCounters.DumpMeNowCount" description="The number of DumpMeNow calls" id="62" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64DumpMeNowCount"></counter>
					<counter name="Packets Received WQE too small" uri="Mlx5.DiagnosticCounters.Packets_Received_WQE_Too_Small" description="The number of packets that reached the Ethernet RQ but cannot fit into the WQE due to their large size." id="63" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uPacketsReceivedEthWqeTooSmall"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Diagnostics Ext 1" symbol="DiagnosticCountersExt1" guid="{9a259406-2e1c-4d6e-94d9-1d5ec2892058}" uri="Mlx5.DiagnosticCountersExt1" description="This set contains diagnostics counters" instances="multipleAggregate">
					<structs>
						<struct name="DiagnosticCounterExt1Struct" type="DiagCountersExt1"></struct>
					</structs>
					<counter name="RoCE Adaptive Retransmission" uri="Mlx5.DiagnosticCountersExt1.RoCEAdaptiveRetransmission" description="Number of adaptive retransmission for RoCE traffic." id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="u32RoCEAdaptiveRetransmission"></counter>
					<counter name="RoCE adaptive retransmission timeouts" uri="Mlx5.DiagnosticCountersExt1.RoCEadaptiveretransmissiontimeouts" description="Number of times RoCE traffic reached timeout due to adaptive retransmission." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="u32RoCEadaptiveretransmissiontimeouts"></counter>
					<counter name="RoCE Slow Restart" uri="Mlx5.DiagnosticCountersExt1.RoCESlowRestart" description="Number of times RoCE slow restart was used." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="u32RoCESlowRestart"></counter>
					<counter name="RoCE Slow Restart CNPs" uri="Mlx5.DiagnosticCountersExt1.RoCESlowRestartCNPs" description="Number of times RoCE slow restart generate CNP packets." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="u32RoCESlowRestartCNPs"></counter>
					<counter name="RoCE Slow Restart Transmission" uri="Mlx5.DiagnosticCountersExt1.RoCESlowRestartTransmission" description="Number of times RoCE slow restart change state to slow restart." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="u32RoCESlowRestartTransmission"></counter>
					<counter name="Checksum calculated by SW/Packet" uri="Mlx5.DiagnosticCounters.CheckSumCalculatedBySW" description="The number of times SW has calculated the checksum" id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="uCheckSumCalculatedBySW"></counter>
					<counter name="CQ Overrun" uri="Mlx5.DiagnosticCountersExt1.CqOverrun" description="Number of times CQs entered an error state due to overflow." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="u32CqOverrun"></counter>
					<counter name="CM DREQ" uri="Mlx5.DiagnosticCountersExt1.CmDreq" description="RDMA disconnect by peer" id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="uCmDreqRcvd"></counter>
					<counter name="Generated Packets dropped due to steering failure" uri="Mlx5.VfDiagCounters.Generated_Packets_Steering_Fail" description="Number of packets generated by the VNIC experiencing unexpected steering failure (at any point in steering flow)" id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64GeneratedPacketsSteeringFail"></counter>
					<counter name="Handled Packets dropped due to steering failure" uri="Mlx5.VfDiagCounters.Handled_Packets_Steering_Fail" description="Number of packets handled by the VNIC experiencing unexpected steering failure (at any point in steering flow owned by the VNIC, including the FDB for the eswitch owner)" id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64HandledPacketsSteeringFail"></counter>
					<counter name="Allocated Memory Pages" uri="Mlx5.DiagnosticCountersExt1.AllocatedMemoryPages" description="Number of memory pages (4KB) allocated for firmware from the host system" id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterExt1Struct" field="u64AllocatedMemoryPages"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Device Diagnostics" symbol="DeviceDiagnosticCounters" guid="{684b7170-ece7-4904-bd68-3b8bac822c36}" uri="Mlx5.DeviceDiagnosticCounters" description="This set contains device diagnostic counters" instances="multipleAggregate">
					<structs>
						<struct name="DeviceDiagnosticCounterStruct" type="DeviceDiagCounters"></struct>
					</structs>
					<counter name="L0 MTT miss" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Miss" description="The number of access to L0 MTT that were missed" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_MISS"></counter>
					<counter name="L0 MTT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Miss_Sec" description="The rate of access to L0 MTT that were missed" id="1" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_MISS_SEC"></counter>
					<counter name="L0 MTT hit" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Hit" description="The number of access to L0 MTT that were hit" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_HIT"></counter>
					<counter name="L0 MTT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Hit_Sec" description="The rate of access to L0 MTT that were hit" id="3" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_HIT_SEC"></counter>
					<counter name="L1 MTT miss" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_Miss" description="The number of access to L1 MTT that were missed" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_MISS"></counter>
					<counter name="L1 MTT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_Miss_Sec" description="The rate of access to L1 MTT that were missed" id="5" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_MISS_SEC"></counter>
					<counter name="L1 MTT hit" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_hit" description="The number of access to L1 MTT that were hit" id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_HIT"></counter>
					<counter name="L1 MTT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_hit_Sec" description="The rate of access to L1 MTT that were hit" id="7" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_HIT_SEC"></counter>
					<counter name="L0 MPT miss" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_miss" description="The number of access to L0 MKey that were missed" id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_MISS"></counter>
					<counter name="L0 MPT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_miss_Sec" description="The rate of access to L0 MKey that were missed" id="9" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_MISS_SEC"></counter>
					<counter name="L0 MPT hit" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_hit" description="The number of access to L0 MKey that were hit" id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_HIT"></counter>
					<counter name="L0 MPT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_hit_Sec" description="The rate of access to L0 MKey that were hit" id="11" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_HIT_SEC"></counter>
					<counter name="L1 MPT miss" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_miss" description="The number of access to L1 MKey that were missed" id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_MISS"></counter>
					<counter name="L1 MPT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_miss_Sec" description="The rate of access to L1 MKey that were missed" id="13" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_MISS_SEC"></counter>
					<counter name="L1 MPT hit" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_hit" description="The number of access to L1 MKey that were hit" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_HIT"></counter>
					<counter name="L1 MPT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_hit_Sec" description="The rate of access to L1 MKey that were hit" id="15" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_HIT_SEC"></counter>
					<counter name="RXS no slow path credits" uri="Mlx5.DeviceDiagnosticCounters.RXS_no_slow_path_credits" description="No room in RXS for slow path packets" id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_NO_SLOW_PATH_CREDITS"></counter>
					<counter name="RXS no fast path credits" uri="Mlx5.DeviceDiagnosticCounters.RXS_no_fast_path_credits" description="No room in RXS for fast path packets" id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_NO_FAST_PATH_CREDITS"></counter>
					<counter name="RXT no slow path credits" uri="Mlx5.DeviceDiagnosticCounters.RXT_no_slow_path_credits" description="No room in RXT for slow path packets" id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_RXT_NO_SLOW_PATH_CRED_PERF_COUNT"></counter>
					<counter name="RXT no fast path credits" uri="Mlx5.DeviceDiagnosticCounters.RXT_no_fast_path_credits" description="No room in RXT for fast path packets" id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_RXT_NO_FAST_PATH_CRED_PERF_COUNT"></counter>
					<counter name="Slow path packets slice load" uri="Mlx5.DeviceDiagnosticCounters.Slow_path_packets_slice_load" description="Number of slow path packets loaded to HCA as slices from the network" id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_CTRL_PERF_SLICE_LOAD_SLOW"></counter>
					<counter name="Fast path packets slice load" uri="Mlx5.DeviceDiagnosticCounters.Fast_path_packets_slice_load" description="Number of fast path packets loaded to HCA as slices from the network" id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_CTRL_PERF_SLICE_LOAD_FAST"></counter>
					<counter name="Steering pipe 0 processing time" uri="Mlx5.DeviceDiagnosticCounters.Steering_pipe_0_processing_time" description="Number of clocks that steering pipe 0 worked" id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE"></counter>
					<counter name="Steering pipe 1 processing time" uri="Mlx5.DeviceDiagnosticCounters.Steering_pipe_1_processing_time" description="Number of clocks that steering pipe 1 worked" id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE"></counter>
					<counter name="WQE address translation back-pressure" uri="Mlx5.DeviceDiagnosticCounters.WQE_address_translation_back_pressure" description="No credits between RXW and TPT" id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_PERF_COUNT_TPT_CREDIT"></counter>
					<counter name="Receive WQE cache miss" uri="Mlx5.DeviceDiagnosticCounters.Receive_WQE_cache_miss" description="Number of packets that got miss in RWqe buffer L0 cache" id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_PERF_WB_MISS"></counter>
					<counter name="Receive WQE cache hit" uri="Mlx5.DeviceDiagnosticCounters.Receive_WQE_cache_hit" description="Number of packets that got hit in RWqe buffer L0 cache" id="26" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_PERF_WB_HIT"></counter>
					<counter name="Slow packets miss in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_miss_in_LDB_L1_cache" description="Number of slow packet that got miss in LDB L1 cache" id="27" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_MISS_LDB"></counter>
					<counter name="Slow packets hit in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_hit_in_LDB_L1_cache" description="Number of slow packet that got hit in LDB L1 cache" id="28" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_HIT_LDB"></counter>
					<counter name="Fast packets miss in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_miss_in_LDB_L1_cache" description="Number of fast packet that got miss in LDB L1 cache" id="29" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_MISS_LDB"></counter>
					<counter name="Fast packets hit in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_hit_in_LDB_L1_cache" description="Number of fast packet that got hit in LDB L1 cache" id="30" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_HIT_LDB"></counter>
					<counter name="Packets miss in LDB L2 cache" uri="Mlx5.DeviceDiagnosticCounters.Packets_miss_in_LDB_L2_cache" description="Number of packet that got miss in LDB L2 cache" id="31" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_MISS_LDB"></counter>
					<counter name="Packets hit in LDB L2 cache" uri="Mlx5.DeviceDiagnosticCounters.Packets_hit_in_LDB_L2_cache" description="Number of packet that got hit in LDB L2 cache" id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_HIT_LDB"></counter>
					<counter name="Slow packets miss in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_miss_in_REQSL_L1" description="Number of slow packet that got miss in REQSL L1 fast cache" id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_MISS_REQSL"></counter>
					<counter name="Slow packets hit in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_hit_in_REQSL_L1" description="Number of slow packet that got hit in REQSL L1 fast cache" id="34" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_HIT_REQSL"></counter>
					<counter name="Fast packets miss in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_miss_in_REQSL_L1" description="Number of fast packet that got miss in REQSL L1 fast cache" id="35" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_MISS_REQSL"></counter>
					<counter name="Fast packets hit in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_hit_in_REQSL_L1" description="Number of fast packet that got hit in REQSL L1 fast cache" id="36" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_HIT_REQSL"></counter>
					<counter name="Packets miss in REQSL L2" uri="Mlx5.DeviceDiagnosticCounters.Packets_miss_in_REQSL_L2" description="Number of packet that got miss in REQSL L2 fast cache" id="37" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_MISS_REQSL"></counter>
					<counter name="Packets hit in REQSL L2" uri="Mlx5.DeviceDiagnosticCounters.Packets_hit_in_REQSL_L2" description="Number of packet that got hit in REQSL L2 fast cache" id="38" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_HIT_REQSL"></counter>
					<counter name="No PXT credits time" uri="Mlx5.DeviceDiagnosticCounters.No_PXT_credits_time" description="Number of clocks in which there were no PXT credits" id="39" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXS_NO_PXT_CREDITS"></counter>
					<counter name="EQ slices busy time" uri="Mlx5.DeviceDiagnosticCounters.EQ_slices_busy_time" description="Number of clocks where all EQ slices were busy" id="40" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXC_EQ_ALL_SLICES_BUSY"></counter>
					<counter name="CQ slices busy time" uri="Mlx5.DeviceDiagnosticCounters.CQ_slices_busy_time" description="Number of clocks where all CQ slices were busy" id="41" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXC_CQ_ALL_SLICES_BUSY"></counter>
					<counter name="MSIX slices busy time" uri="Mlx5.DeviceDiagnosticCounters.MSIX_slices_busy_time" description="Number of clocks where all MSIX slices were busy" id="42" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXC_MSIX_ALL_SLICES_BUSY"></counter>
					<counter name="QP done due to VL limited" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_VL_limited" description="Number of QP done scheduling due to VL limited (e.g. lack of VL credits)" id="43" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_VL_LIMITED"></counter>
					<counter name="QP done due to desched" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_desched" description="Number of QP done scheduling due to desched (Tx full burst size)" id="44" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_DESCHED"></counter>
					<counter name="QP done due to work done" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_work_done" description="Number of QP done scheduling due to work done (Tx all QP data)" id="45" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_WORK_DONE"></counter>
					<counter name="QP done due to limited" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_limited" description="Number of QP done scheduling due to limited rate(e.g. max read)" id="46" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_LIMITED"></counter>
					<counter name="QP done due to E2E credits" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_E2E_creadits" description="Number of QP done scheduling due to e2e credits (other peer credits)" id="47" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_E2E_CREDITS"></counter>
					<counter name="Packets sent by SXW to SXP" uri="Mlx5.DeviceDiagnosticCounters.Packets_sent_by_SXW_to_SXP" description="Number of packets that were authorized to send by SXW (to SXP)" id="48" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PACKET_SEND_SXW2SXP_GO_VLD"></counter>
					<counter name="Steering hit" uri="Mlx5.DeviceDiagnosticCounters.Steering_hit" description="Number of steering lookups that were hit" id="49" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PERF_COUNT_STEERING_HIT"></counter>
					<counter name="Steering miss" uri="Mlx5.DeviceDiagnosticCounters.Steering_miss" description="Number of steering lookups that were miss" id="50" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PERF_COUNT_STEERING_MISS"></counter>
					<counter name="Steering processing time" uri="Mlx5.DeviceDiagnosticCounters.Steering_processing_time" description="Number of clocks that steering pipe worked" id="51" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PERF_COUNT_STEERING_RSE_0"></counter>
					<counter name="No send credits for scheduling time" uri="Mlx5.DeviceDiagnosticCounters.No_send_credits_for_scheduling_time" description="The number of clocks that were no credits for scheduling (Tx)" id="52" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXD_NO_SCHED_CREDITS"></counter>
					<counter name="No slow path send credits for scheduling time" uri="Mlx5.DeviceDiagnosticCounters.No_slow_path_send_credits_for_scheduling_time" description="The number of clocks that were no credits for scheduling (Tx) for slow path" id="53" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXD_NO_SLOW_PATH_SCHED_CREDITS"></counter>
					<counter name="TPT indirect memory key access" uri="Mlx5.DeviceDiagnosticCounters.TPT_indirect_memory_key_access" description="The number of indirect mkey accesses" id="54" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_TPT_INDIRECT_MEM_KEY"></counter>
					<counter name="Available Dynamic MSI-X Count" uri="Mlx5.DeviceDiagnosticCounters.Num_Available_Dynamic_Msix" description="Number of available Dynamic MSI-X" id="55" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_NUM_AVAILABLE_DYNAMIC_MSIX"></counter>
					<counter name="Total Dynamic MSI-X Count" uri="Mlx5.DeviceDiagnosticCounters.Total_Available_Dynamic_Msix" description="Number of total Dynamic MSI-X Count" id="56" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_NUM_TOTAL_DYNAMIC_MSIX_COUNT"></counter>
					<counter name="Internal RQ out of buffer" uri="Mlx5.DeviceDiagnosticCounters.Internal_RQ_out_of_buffer" description="Number of times the device that owned the queue had insufficient number of buffers allocated." id="57" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_INTERNAL_RQ_OUT_OF_BUFFER"></counter>
					<counter name="Nic temperature in Celsius degrees unit" uri="Mlx5.DeviceDiagnosticCounters.Nic_Temperature_in_Celsius_unit" description="The temperature of the NIC in Celsius degrees unit." id="58" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_NIC_TEMPERATURE_IN_CELSIUS_UNIT"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 PCI Device Diagnostics" symbol="PciDeviceDiagnosticCounters" guid="{3967c534-b821-49e1-af1b-0d6055496b29}" uri="Mlx5.PciDeviceDiagnosticCounters" description="This set contains PCI device diagnostic counters" instances="multipleAggregate">
					<structs>
						<struct name="PciDeviceDiagnosticCounterStruct" type="PciDeviceDiagCounters"></struct>
					</structs>
					<counter name="PCI back-pressure cycles" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Back_Pressure_Cycles" description="The number of clocks where BP from PCI was received while trying to send packet to the host" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PXD_READ_BP"></counter>
					<counter name="PCI back-pressure cycles/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Back_Pressure_Cycles_Sec" description="The rate of clocks where BP from PCI was received while trying to send packet to the host" id="1" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PXD_READ_BP_SEC"></counter>
					<counter name="PCI write back-pressure cycles" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Write_Back_Pressure_Cycles" description="The number of clocks where there was lack of posted outbound credits from PCI while trying to send packet to the host" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_WRITE_BP"></counter>
					<counter name="PCI write back-pressure cycles/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Write_Back_Pressure_Cycles_Sec" description="The rate of clocks where there was lack of posted outbound credits from PCI while trying to send packet to the host" id="3" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_WRITE_BP_SEC"></counter>
					<counter name="PCI read back-pressure cycles" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Read_Back_Pressure_Cycles" description="The number of clocks where there was lack of non-posted outbound credits from PCI while trying to send packet to the host" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_READ_BP"></counter>
					<counter name="PCI read back-pressure cycles/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Read_Back_Pressure_Cycles_Sec" description="The rate of clocks where there was lack of non-posted outbound credits from PCI while trying to send packet to the host" id="5" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_READ_BP_SEC"></counter>
					<counter name="PCI read stuck no receive buffer" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Read_Stuck_No_Receive_Buffer" description="The number of clocks where there was lack in global byte credits for non-posted outbound from PCI while trying to send packet to the host" id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_READ_STUCK_NO_COMPLETION_BUFFER"></counter>
					<counter name="Available PCI BW" uri="Mlx5.PciDeviceDiagnosticCounters.Available_PCI_BW" description="The number of 128 bytes that could have been received from the host" id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_MAX_PCI_BW"></counter>
					<counter name="Used PCI BW" uri="Mlx5.PciDeviceDiagnosticCounters.Used_PCI_BW" description="The number of 128 bytes that have been received from the host" id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_USED_PCI_BW"></counter>
					<counter name="RX PCI errors" uri="Mlx5.PciDeviceDiagnosticCounters.RX_PCI_errors" description="Counts physical layer PCIe signal integrity errors, the number of transitions to recovery due to Framing errors and CRC (dlp and tlp). If the counter is advancing, try to change the PCIe slot in use. Note: Only a continues increment of the counter value is considered an error." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="uRxPciErrors"></counter>
					<counter name="TX PCI errors" uri="Mlx5.PciDeviceDiagnosticCounters.TX_PCI_errors" description="Counts physical layer PCIe signal integrity errors, the number of transition to recovery initiated by the other side (moving to Recovery due to getting TS/EIEOS). If the counter is advancing, try to change the PCIe slot in use. Note: Only a continues increment of the counter value is considered an error." id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="uTxPciErrors"></counter>
					<counter name="TX PCI non-fatal errors" uri="Mlx5.PciDeviceDiagnosticCounters.TX_PCI_non_fatal_errors" description="Counts PCI transport layer Non-Fatal error msg sent. If the counter is advancing, try to change the PCIe slot in use." id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="uTxPciNonFatalErrors"></counter>
					<counter name="TX PCI fatal errors" uri="Mlx5.PciDeviceDiagnosticCounters.TX_PCI_fatal_errors" description="Counts PCIe transport layer fatal error msg sent. If the counter is advancing, try to change the PCIe slot in use." id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="uTxPciFatalErrors"></counter>
					<counter name="RX PACKET DROPS PCIe BUFFERS" uri="Mlx5.PciDeviceDiagnosticCounters.RX_PACKET_DROPS_PCIe_BUFFERS" description="packets dropped due to lack of PCIe buffers on receive path from NIC port toward the hosts." id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_tx_overflow_buffer_pkt"></counter>
					<counter name="RX PACKET MARKED PCIe BUFFERS" uri="Mlx5.PciDeviceDiagnosticCounters.RX_PACKET_MARKED_PCIe_BUFFER" description="packets marked due to lack of PCIe buffers on receive path from NIC port toward the hosts." id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_tx_overflow_buffer_marked_pkt"></counter>
					<counter name="PCI link width" uri="Mlx5.PciDeviceDiagnosticCounters.uPciLinkWidth" description="the current width of PCIe link. In order to get the overall PCIe bandwidth, the PCI link width should be multiply by PCI link speed " id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PciLinkWidth"></counter>
					<counter name="PCI link speed" uri="Mlx5.PciDeviceDiagnosticCounters.uPciLinkSpeed" description="the current speed of PCIe link. In order to get the overall PCIe bandwidth, the PCI link speed MT/Sec should be multiply by PCI link width " id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PciLinkSpeed"></counter>
					<counter name="Available PCI BW/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.Available_PCI_BW_SEC" description="The rate of the number of 128 bytes that could have been received from the host" id="17" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_MAX_PCI_BW_SEC"></counter>
					<counter name="Used PCI BW/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.Used_PCI_BW_SEC" description="The rate of the number of 128 bytes that have been received from the host" id="18" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_USED_PCI_BW_SEC"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Rss Counters" symbol="RssDiagCounters" guid="{c79149a1-04b2-465a-9bee-78563cacee16}" uri="Mlx5.RssDiagCounters" description="Show counters for RSS traffic per CPU" instances="multipleAggregate">
					<structs>
						<struct name="RssDiagCountersBuf" type="RssDiagnosticCounters"></struct>
					</structs>
					<counter name="Rss IPv4 Only" uri="Mlx5.RssDiagCounters.Rss_IPv4_Only" description="Shows the number of received packets that have RSS hash calculated on IPv4 header only" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv4_Only"></counter>
					<counter name="Rss IPv4/Tcp" uri="Mlx5.RssDiagCounters.Rss_IPv4_Tcp" description="Shows the number of received packets that have RSS hash calculated on IPv4 and Tcp headers" id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv4_Tcp"></counter>
					<counter name="Rss IPv4/Udp" uri="Mlx5.RssDiagCounters.Rss_IPv4_Udp" description="Shows the number of received packets that have RSS hash calculated on IPv4 and Udp headers" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv4_Udp"></counter>
					<counter name="Rss IPv6 Only" uri="Mlx5.RssDiagCounters.Rss_IPv6_Only" description="Shows the number of received packets that have RSS hash calculated on IPv6 header only" id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv6_Only"></counter>
					<counter name="Rss IPv6/Tcp" uri="Mlx5.RssDiagCounters.Rss_IPv6_Tcp" description="Shows the number of received packets that have RSS hash calculated on IPv6 and Tcp headers" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv6_Tcp"></counter>
					<counter name="Rss IPv6/Udp" uri="Mlx5.RssDiagCounters.Rss_IPv6_Udp" description="Shows the number of received packets that have RSS hash calculated on IPv6 and Udp headers" id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv6_Udp"></counter>
					<counter name="Encapsulated Rss IPv4 Only" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv4_Only" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv4 header only" id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv4_Only"></counter>
					<counter name="Encapsulated Rss IPv4/Tcp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv4_Tcp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv4 and Tcp headers" id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv4_Tcp"></counter>
					<counter name="Encapsulated Rss IPv4/Udp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv4_Udp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv4 and Udp headers" id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv4_Udp"></counter>
					<counter name="Encapsulated Rss IPv6 Only" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv6_Only" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv6 header only" id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv6_Only"></counter>
					<counter name="Encapsulated Rss IPv6/Tcp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv6_Tcp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv6 and Tcp headers" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv6_Tcp"></counter>
					<counter name="Encapsulated Rss IPv6/Udp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv6_Udp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv6 and Udp headers" id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv6_Udp"></counter>
					<counter name="NonRss IPv4 Only" uri="Mlx5.RssDiagCounters.NonRss_IPv4_Only" description="Shows the number of Ipv4only packets that have no RSS hash calculated by HW" id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv4_Only"></counter>
					<counter name="NonRss IPv4/Tcp" uri="Mlx5.RssDiagCounters.NonRss_IPv4_Tcp" description="SShows the number of Ipv4Tcp packets that have no RSS hash calculated by HW" id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv4_Tcp"></counter>
					<counter name="NonRss IPv4/Udp" uri="Mlx5.RssDiagCounters.NonRss_IPv4_Udp" description="Shows the number of Ipv4Udp packets that have no RSS hash calculated by HW" id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv4_Udp"></counter>
					<counter name="NonRss IPv6 Only" uri="Mlx5.RssDiagCounters.NonRss_IPv6_Only" description="Shows the number of Ipv6Only packets that have no RSS hash calculated by HW" id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv6_Only"></counter>
					<counter name="NonRss IPv6/Tcp" uri="Mlx5.RssDiagCounters.NonRss_IPv6_Tcp" description="Shows the number of Ipv6Tcp packets that have no RSS hash calculated by HW" id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv6_Tcp"></counter>
					<counter name="NonRss IPv6/Udp" uri="Mlx5.RssDiagCounters.NonRss_IPv6_Udp" description="Shows the number of Ipv6Udp packets that have no RSS hash calculated by HW" id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv6_Udp"></counter>
					<counter name="Encapsulated NonRss IPv4 Only" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv4_Only" description="Shows the number of encapsulated Ipv4Only packets that have no RSS hash calculated by HW" id="30" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv4_Only"></counter>
					<counter name="Encapsulated NonRss IPv4/Tcp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv4_Tcp" description="Shows the number of encapsulated Ipv4Tcp packets that have no RSS hash calculated by HW" id="31" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv4_Tcp"></counter>
					<counter name="Encapsulated NonRss IPv4/Udp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv4_Udp" description="Shows the number of encapsulated Ipv4Udp packets that have no RSS hash calculated by HW" id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv4_Udp"></counter>
					<counter name="Encapsulated NonRss IPv6 Only" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv6_Only" description="Shows the number of encapsulated Ipv6Only packets that have no RSS hash calculated by HW" id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv6_Only"></counter>
					<counter name="Encapsulated NonRss IPv6/Tcp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv6_Tcp" description="Shows the number of encapsulated Ipv6Tcp packets that have no RSS hash calculated by HW" id="34" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv6_Tcp"></counter>
					<counter name="Encapsulated NonRss IPv6/Udp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv6_Udp" description="Shows the number of encapsulated Ipv6Udp packets that have no RSS hash calculated by HW" id="35" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv6_Udp"></counter>
					<counter name="Rss Misc" uri="Mlx5.RssDiagCounters.Rss_Misc" description="Shows the number of received packets that have RSS hash calculated with unknown RSS hash type" id="40" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Misc"></counter>
					<counter name="Encapsulated Rss Misc" uri="Mlx5.RssDiagCounters.Encap_Rss_Misc" description="Shows the number of received encapsulated packets that have RSS hash calculated with unknown RSS hash type" id="41" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_Misc"></counter>
					<counter name="NonRss Misc" uri="Mlx5.RssDiagCounters.NonRss_Misc" description="Shows the number of packets that have no RSS hash calculated by HW without clear reason for that" id="42" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Misc"></counter>
					<counter name="Encapsulated NonRss Misc" uri="Mlx5.RssDiagCounters.Encap_NonRss_Misc" description="Shows the number of encapsulated packets that have no RSS hash calculated by HW without clear reason for that" id="43" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_Misc"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 VF Diagnostics" symbol="VFDiagnosticCounters" guid="{07903cf9-ed03-4c6c-890e-76cd44e9a98b}" uri="Mlx5.VFDiagnosticCounters" description="This set contains Virtual Function (VF) diagnostic counters" instances="multipleAggregate">
					<structs>
						<struct name="VFDiagnosticCountersStruct" type="VfDiagCounters"></struct>
					</structs>
					<counter name="Async EQ Overrun" uri="Mlx5.VfDiagCounters.Async_EQ_Overrun" description="Number of times an EQ mapped to Async events queue encountered overrun queue" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uAsyncEqOverrun"></counter>
					<counter name="Completion EQ Overrun" uri="Mlx5.VfDiagCounters.Completion_EQ_Overrun" description="Number of times an EQ mapped to Completion events queue encountered overrun queue" id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uCompletionEqOverrun"></counter>
					<counter name="Current queues under processor handle" uri="Mlx5.VfDiagCounters.CurrentQUnderProcessorHandle" description="The current number of queues that are handled by the processor due to async error (e.g. retry exceeded) or due to errored cmd (e.g. 2eer_qp cmd). Value constantly greater than zero, may indicating about queues in error state." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uCurrentQUnderProcessorHandle"></counter>
					<counter name="Total queues under processor handle" uri="Mlx5.VfDiagCounters.TotalQUnderProcessorHandle" description="The total number of queues that are handled by the processor due to async error (e.g. retry exceeded) or due to errored cmd (e.g. 2eer_qp cmd). Value greater than zero may be normal and expected (for example, sometimes queues are transited to error before closing)." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uTotalQUnderProcessorHandle"></counter>
					<counter name="Packets Received dropped due to Steering" uri="Mlx5.VfDiagCounters.Packets_Received_Steering_Dropped" description="Number of packets that completed the NIC Receive FlowTable steering and were discarded due to lack of match rule in Flow Table." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64PacketsReceivedSteeringDropped"></counter>
					<counter name="Packets Received dropped due to VPort Down" uri="Mlx5.VfDiagCounters.Packets_Received_VPort_Down_Dropped" description="Number of packets that were steered to a VPort, and discarded because the VPort was not in a state to receive packets." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64PacketsReceivedVPortDownDropped"></counter>
					<counter name="Packets Transmitted dropped due to VPort Down" uri="Mlx5.VfDiagCounters.Packets_Transmited_VPort_Down_Dropped" description="Number of packets that were transmitted by a vNIC, and discarded because the VPort was not in a state to transmit packets." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64PacketsTransmittedVPortDownDropped"></counter>
					<counter name="Invalid Commands" uri="Mlx5.VfDiagCounters.Invalid_commands" description="Number of commands issued by the VF and failed." id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uInvalidCommands"></counter>
					<counter name="Send Queue Priority Update Flow" uri="Mlx5.VfDiagCounters.SendQueuePriorityUpdateFlow" description="The total number of QP/SQ priority/SL update events." id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uSendQueuePriorityUpdateFlow"></counter>
					<counter name="Quota Exceeded Command" uri="Mlx5.VfDiagCounters.QuotaExceededCommands" description="Number of commands issued by the VF and failed due to quota being exceeded." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uQuotaExceededCommands"></counter>
					<counter name="Packets Received WQE too small" uri="Mlx5.VfDiagCounters.Packets_Received_WQE_Too_Small" description="The number of packets that reached the Ethernet RQ but cannot fit into the WQE due to their large size." id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uPacketsReceivedEthWqeTooSmall"></counter>
					<counter name="CQ Overrun" uri="Mlx5.VfDiagCounters.CqOverrun" description="Number of times CQs entered an error state due to overflow." id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uCqOverrun"></counter>
					<counter name="Packets Received dropped due to lack of receive WQEs" uri="Mlx5.VfDiagCounters.Packets_Received_No_Wqe_Dropped" description="Number of dropped packets due to lack of receive WQEs for an internal device RQs." id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="uInternalRqOutOfBuffer"></counter>
					<counter name="Generated Packets dropped due to steering failure" uri="Mlx5.VfDiagCounters.Generated_Packets_Steering_Fail" description="Number of packets generated by the VNIC experiencing unexpected steering failure (at any point in steering flow)" id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64GeneratedPacketsSteeringFail"></counter>
					<counter name="Handled Packets dropped due to steering failure" uri="Mlx5.VfDiagCounters.Handled_Packets_Steering_Fail" description="Number of packets handled by the VNIC experiencing unexpected steering failure (at any point in steering flow owned by the VNIC, including the FDB for the eswitch owner)" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64HandledPacketsSteeringFail"></counter>
					<counter name="Requester Timeout Received" uri="Mlx5.VfDiagCounters.Requester_time_out_received" description="Number of time out received when the local machine generates outbound traffic." id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RequesterTimeOutReceived"></counter>
					<counter name="Requester Out of Order Sequence NAK" uri="Mlx5.VfDiagCounters.Requester_out_of_order_sequence_NAK" description="Number of Out of Sequence NAK received when the local machine generates outbound traffic, i.e. the number of times the local machine received NAKs indicating OOS on the receiving side" id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RequesterOOOSeqNAKReceived"></counter>
					<counter name="Requester RNR NAK" uri="Mlx5.VfDiagCounters.Requester_RNR_NAK" description="Number of RNR (Receiver Not Ready) NAKs received when the local machine generates outbound traffic" id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RequesterRNRNAK"></counter>
					<counter name="Responder RNR NAK" uri="Mlx5.VfDiagCounters.Responder_RNR_NAK" description="Number of RNR (Receiver Not Ready) NAKs sent when the local machine receives inbound traffic" id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ResponderRNRNAK"></counter>
					<counter name="Responder Out of Order Sequence Received" uri="Mlx5.VfDiagCounters.Responder_out_of_order_sequence_received" description="Number of Out of Sequence packet received when the local machine receives inbound traffic, i.e. the number of times the local machine received messages that are not consecutive" id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ResponderOOOSeqReceived"></counter>
					<counter name="Responder Duplicate Request Received" uri="Mlx5.VfDiagCounters.Responder_duplicate_request_received" description="Number of duplicate requests received when the local machine receives inbound traffic" id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ResponderDuplicateRequestRecv"></counter>
					<counter name="Requester RNR NAK Retries Exceeded Error" uri="Mlx5.VfDiagCounters.Requester_RNR_NAK_retries_exceeded_errors" description="Number of RNR (Receiver Not Ready) NAKs retries exceeded errors when the local machine generates outbound traffic" id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RequesterRNRNAKRetriesExceededErr"></counter>
					<counter name="Responder Local Length Errors" uri="Mlx5.VfDiagCounters.Responder_local_length_errors" description="Number of times responder detected local length errors" id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RespLocalLengthErr"></counter>
					<counter name="Requester Local Length Errors" uri="Mlx5.VfDiagCounters.Requester_local_length_errors" description="Number of times requester detected local length errors" id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqLocalLengthErr"></counter>
					<counter name="Responder Local QP Operation Errors" uri="Mlx5.VfDiagCounters.Requester_local_qp_errors" description="Number of times responder detected local QP operation errors" id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RespLocalQpErr"></counter>
					<counter name="Responder Local Protection Errors" uri="Mlx5.VfDiagCounters.Responder_local_protection_errors" description="Number of times responder detected memory protection error in its local memory subsystem" id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RespLocalProtection"></counter>
					<counter name="Requester Local Protection Errors" uri="Mlx5.VfDiagCounters.Requester_local_protection_errors" description="Number of times requester detected memory protection error in its local memory subsystem" id="26" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqLocalProtection"></counter>
					<counter name="Responder CQEs with Error" uri="Mlx5.VfDiagCounters.Responder_cqe_error" description="Number of times responder flow reported a completion with error" id="27" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RespCqeErr"></counter>
					<counter name="Requester CQEs with Error" uri="Mlx5.VfDiagCounters.Requester_cqe_error" description="Number of times requester flow reported a completion with error" id="28" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqCqeErr"></counter>
					<counter name="Requester Memory Window Binding Errors" uri="Mlx5.VfDiagCounters.Requester_mem_win_bind_error" description="Number of times requester detected memory window binding error" id="29" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqMemWinBindErr"></counter>
					<counter name="Requester Bad Response" uri="Mlx5.VfDiagCounters.Requester_bad_response" description="Number of times an unexpected transport layer opcode was returned by the responder" id="30" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqBadResponse"></counter>
					<counter name="Requester Remote Invalid Request Errors" uri="Mlx5.VfDiagCounters.Requester_remote_invalid_request" description="Number of times requester detected remote invalid request error" id="31" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqRemoteInvalidReq"></counter>
					<counter name="Responder Remote Invalid Request Errors" uri="Mlx5.VfDiagCounters.Responder_remote_invalid_request" description="Number of times responder detected remote invalid request error" id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RespRemoteInvalidReq"></counter>
					<counter name="Requester Remote Access Errors" uri="Mlx5.VfDiagCounters.Requester_remote_access_errors" description="Number of times requester detected remote access error" id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqRemoteAccessErr"></counter>
					<counter name="Responder Remote Access Errors" uri="Mlx5.VfDiagCounters.Responder_remote_access_errors" description="Number of times responder detected remote access error" id="34" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RespRemoteAccessErr"></counter>
					<counter name="Requester Remote Operation Errors" uri="Mlx5.VfDiagCounters.Requester_operation_errors" description="Number of times requester detected remote operation error." id="35" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqRemoteOpErr"></counter>
					<counter name="Requester Retry Exceeded Errors" uri="Mlx5.VfDiagCounters.Requester_retry_exceeded_errors" description="Number of times requester detected transport retries exceed error" id="36" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqTransportRetriesExceeded"></counter>
					<counter name="Received RDMA Write requests" uri="Mlx5.VfDiagCounters.ReceivedRDMAWriteRequests" description="Number of RDMA write requests received" id="37" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RxWriteRequests"></counter>
					<counter name="Received RDMA Read requests" uri="Mlx5.VfDiagCounters.ReceivedRDMAReadRequests" description="Number of RDMA read requests received" id="38" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RxReadRequests"></counter>
					<counter name="Responder CQEs flushed with error" uri="Mlx5.VfDiagCounters.RespCqeFlushError" description="Number of responder CQEs flushed with error flowing queue transition to error state" id="39" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64RespCqeFlushError"></counter>
					<counter name="Requester CQEs flushed with error" uri="Mlx5.VfDiagCounters.ReqCqeFlushError" description="Number of requester CQEs flushed with error flowing queue transition to error state" id="40" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64ReqCqeFlushError"></counter>
					<counter name="Requester QP Transport Retries Exceeded Errors" uri="Mlx5.VfDiagCounters.Requester_QP_Transport_Retries_Exceeded_Errors" description="Requester number of transport retries exceeded EXT_QP_MAX_RETRY_LIMIT in EXT_QP_MAX_RETRY_PERIOD seconds" id="41" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64MaxQpRetryFreqExceeded"></counter>
					<counter name="Allocated Memory Pages" uri="Mlx5.VfDiagCounters.AllocatedMemoryPages" description="Number of memory pages (4KB) allocated for VF firmware from the host system" id="42" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VFDiagnosticCountersStruct" field="u64AllocatedMemoryPages"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Receive Datapath Counters" symbol="RxDatapathCounters" guid="{59a3d6c6-c944-4d59-b00f-7da406fa2bfb}" uri="Mlx5.RxDatapathCounters" description="This set contains per receive ring counters" instances="multiple">
					<structs>
						<struct name="RxDatapathCountersStruct" type="recv_perf_counters"></struct>
					</structs>
					<counter name="Cpu Number" uri="Mlx5.recv_perf_counters.CpuNum" description="The CPU where the driver process the queue completions." id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="CpuNum"></counter>
					<counter name="Drops due to completion queue errors" uri="Mlx5.recv_perf_counters.DropsDueToCqeErrors" description="The number of Receive Drops Due To Cqe Errors." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="DropsDueToCqeErrors"></counter>
					<counter name="Drops due to invalid packet size" uri="Mlx5.recv_perf_counters.DropsDueToInvalidRxPktSize" description="Advanced when a packet is received with size that is larger than the maximum MTU size allowed, which is the max size HW supports. The value can be checked using the NDIS miniport adapter general attributes struct in the field MTuSize." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="DropsDueToInvalidRxPktSize"></counter>
					<counter name="Number of receive buffers posted" uri="Mlx5.recv_perf_counters.NumRxBuffersPosted" description="When this counter is not advancing, the SW/HW might be stuck. Meaning, either the SW is not processing the receive requests or the HW is not using the post receives. To check the state of WQ/CQ, check the error events log messages." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="NumRxBuffersPosted"></counter>
					<counter name="Average packet count per indicate" uri="Mlx5.recv_perf_counters.AvgPktCountPerIndicate" description="The average of the handled send packets per indicate calls to NDIS. The average is the number of packets completed /number of indicates to NDIS." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="AvgPktCountPerIndicate"></counter>
					<counter name="Packets in low resource mode" uri="Mlx5.recv_perf_counters.PacketsLowResources" description="When a forced low resource (Registry ForceLowResourcesIndication is 1, when the default is 0) or the number of outstanding post receive is lower than the minimum number of RFDs configured (Regestry is NicMinRfds)." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="PacketsLowResources"></counter>
					<counter name="Packets processed in interrupt mode" uri="Mlx5.recv_perf_counters.PacketsReceivedDPC" description="The number of packets indicated to NDIS during interrupt. The counter progresses as the argument NumberOfNetBufferLists in the function NdisMIndicateReceiveNetBufferLists progresses when it is called during interrupt handling." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="PacketsReceivedDPC"></counter>
					<counter name="Number of interrupts" uri="Mlx5.recv_perf_counters.NumberOfInterrupts" description="Number of Receive Datapath interrupts." id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="NumberOfInterrupts"></counter>
					<counter name="Packets processed in polling mode" uri="Mlx5.recv_perf_counters.PacketsReceivedPolling" description="The number of packets indicated to NDIS while in polling mode." id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="PacketsReceivedPolling"></counter>
					<counter name="Consumed max receives" uri="Mlx5.recv_perf_counters.ConsumedMaxReceives" description="Number of times the driver processed the number of packets that is higher than the maximum calls to NDIS Indicate (the value shown in Registry MaxCallsToNdisIndicate). When this counter progresses, the driver stops processing any more packets." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="ConsumedMaxReceives"></counter>
					<counter name="DpcWatchDog (SingleDpc) Starvation" uri="Mlx5.recv_perf_counters.DpcWatchDogSingleDpcStarvation" description="The number of times the driver had watchdog starvation during DPC and re-submitted a DPC. When this counter progresses, DPC does not process any packets, meaning counters 6-10 will not progress." id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="DpcWatchDogSingleDpcStarvation"></counter>
					<counter name="DpcWatchDog (TotalDpc) Starvation" uri="Mlx5.recv_perf_counters.DpcWatchDogTotalDpcStarvation" description="The number of times the driver had watchdog starvation during DPC and moved to. When this counter progresses, DPC does not process any packets, meaning counters 6-10 will not progress." id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="DpcWatchDogTotalDpcStarvation"></counter>
					<counter name="Number of traffic profile transitions" uri="Mlx5.recv_perf_counters.NumTrafficProfileTransitions" description="Number of times the core’s Receive Queue changed traffic Latency/ Throughput." id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="NumTrafficProfileTransitions"></counter>
					<counter name="Interrupts on incorrect cpu" uri="Mlx5.recv_perf_counters.InterruptsOnIncorrectCpu" description="The number of received interrupts on a wrong CPU. In this case, the driver re-submits a DPC on the correct CPU." id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="InterruptsOnIncorrectCpu"></counter>
					<counter name="Ecn Marked Packets(Ipv4)" uri="Mlx5.recv_perf_counters.EcnMarkedPacketsIpv4" description="The number of times the driver marked an IPv4 packet with ECN." id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="EcnMarkedPacketsIpv4"></counter>
					<counter name="Ecn Marked Packets(Ipv6)" uri="Mlx5.recv_perf_counters.EcnMarkedPacketsIpv6" description="The number of times the driver marked an IPv6 packet with ECN." id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="EcnMarkedPacketsIpv6"></counter>
					<counter name="Strided Wqes" uri="Mlx5.recv_perf_counters.uStridedWqes" description="The number of Wqes that its strides are consumed by the HW. They should progress only if StridingRQ feature is enabled (check in Regestry StridingRqEnabled). \nCounters: For every N > 0 packets received, the packetsCounter should be incremented by N. The wqe counter can be incremented by [upper bound(N/number of strides in wqe) ,N]." id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="uStridedWqes"></counter>
					<counter name="Packets processed in NDIS poll mode" uri="Mlx5.recv_perf_counters.PacketsConsumedByNdisPollApi" description="When the feature is enabled, counter for Packets processed in Interrupt mode or Packets processed in poll mode are not counters incremented." id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="RxDatapathCountersStruct" field="PacketsConsumedByNdisPollApi"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Transmit Datapath Counters" symbol="TxDatapathCounters" guid="{e8e06605-596b-463b-8d75-a4a1206886de}" uri="Mlx5.TxDatapathCounters" description="This set contains per transmit ring counters" instances="multiple">
					<structs>
						<struct name="TxDatapathCountersStruct" type="send_perf_counters"></struct>
					</structs>
					<counter name="Cpu Number" uri="Mlx5.send_perf_counters.CpuNum" description="The CPU where the driver process the queue completions." id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="CpuNum"></counter>
					<counter name="Drops due to invalid packet size" uri="Mlx5.send_perf_counters.DropsDueToInvalidLength" description="Number of packets with invalid size, OS call to build SGL failed counter should also progress in this case." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="DropsDueToInvalidLength"></counter>
					<counter name="OS call to build SGL failed" uri="Mlx5.send_perf_counters.TxProcessSGFailed" description="The LSO header size cannot be received if SKB allocation fails or the packet has an invalid size" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="TxProcessSGFailed"></counter>
					<counter name="Transmit copy packets" uri="Mlx5.send_perf_counters.TxCopyPackets" description="Counts the number of times a packet should be copied during sends. This could happen in case a packet has a size larger than supported by the HW." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="TxCopyPackets"></counter>
					<counter name="Transmit ring is full" uri="Mlx5.send_perf_counters.TxRingIsFull" description="Counts the time the transmit ring was full during sends." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="TxRingIsFull"></counter>
					<counter name="Number of packets posted" uri="Mlx5.send_perf_counters.SendPosted" description="The number of send requests that have been forwarded to the HW, (packets that are pending aren’t counted)." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="SendPosted"></counter>
					<counter name="Number of packets completed" uri="Mlx5.send_perf_counters.CompletionCount" description="Counts the number of processed and completed sends, when it progress, the resources allocated to the sent packet is freed." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="CompletionCount"></counter>
					<counter name="Average packet count per indicate" uri="Mlx5.send_perf_counters.AvgPktCountPerIndicate" description="The average of the handled send packets per indicate calls to NDIS. The average is the number of packets completed /number of indicates to NDIS." id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="AvgPktCountPerIndicate"></counter>
					<counter name="Interrupts on incorrect cpu" uri="Mlx5.send_perf_counters.InterruptsOnIncorrectCpu" description="The number of times the TX received a completion on the wrong CPU. In such case, the driver re-submits a DCP on the correct CPU." id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="InterruptsOnIncorrectCpu"></counter>
					<counter name="Number of packets posted in bypass mode" uri="Mlx5.send_perf_counters.TxPostSglAllocBypass" description="Number of packets detected by driver as forwarded." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="TxPostSglAllocBypass"></counter>
					<counter name="Drops due to completion queue errors" uri="Mlx5.send_perf_counters.DropsDueToCqeErrors" description="Send Drops Due To Cqe Errors" id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="DropsDueToCqeErrors"></counter>
					<counter name="Number of traffic profile transitions" uri="Mlx5.send_perf_counters.NumTrafficProfileTransitions" description="Number of traffic profile transitions" id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="NumTrafficProfileTransitions"></counter>
					<counter name="Packets processed in interrupt mode" uri="Mlx5.send_perf_counters.PacketsProcessedDPC" description="Packets processed in Interrupt mode" id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="PacketsProcessedDPC"></counter>
					<counter name="Packets processed in polling mode" uri="Mlx5.send_perf_counters.PacketsProcessedPolling" description="Packets processed in polling mode" id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="PacketsProcessedPolling"></counter>
					<counter name="Packets processed in NDIS poll mode" uri="Mlx5.send_perf_counters.PacketsConsumedByNdisPollApi" description="Packets processed in Ndis mode" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="TxDatapathCountersStruct" field="PacketsConsumedByNdisPollApi"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Port Diagnostics" symbol="PortDiagnosticCounters" guid="{462ed426-2ca2-4a18-b7d5-15587cce8e33}" uri="Mlx5.PortDiagnosticCounters" description="This set contains additional port diagnostic counters" instances="multipleAggregate">
					<structs>
						<struct name="PortDiagnosticCounterStruct" type="PortDiagCounters"></struct>
					</structs>
					<counter name="RX Kbits phy" symbol="RX_Kbits_phy" uri="Mlx5.PortDiagnosticCounters.rx_kbits_phy" description="The total amount of traffic that could have been received." id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_kbits_phy"></counter>
					<counter name="RX PCS Symbol Error phy" symbol="RX_PCS_Symbol_Error_phy" uri="Mlx5.PortDiagnosticCounters.rx_pcs_symbol_err_phy" description="The number of symbol errors that wasn’t corrected by FEC  and that traffic was lost." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_pcs_symbol_err_phy"></counter>
					<counter name="RX PCS Corrected Bits phy" symbol="RX_PCS_Corrected_Bits_phy" uri="Mlx5.PortDiagnosticCounters.rx_pcs_corrected_bits_phy" description="The number of corrected bits on this port according to active FEC (RS/FC)." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_pcs_corrected_bits_phy"></counter>
					<counter name="RX Error Lane0 phy" symbol="RX_Error_Lane0_phy" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_0_phy" description="The number error bits on lane 0." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_0_phy"></counter>
					<counter name="RX Error Lane1 phy" symbol="RX_Error_Lane1_phy" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_1_phy" description="The number error bits on lane 1." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_1_phy"></counter>
					<counter name="RX Error Lane2 phy" symbol="RX_Error_Lane2_phy" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_2_phy" description="The number error bits on lane 2." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_2_phy"></counter>
					<counter name="RX Error Lane3 phy" symbol="RX_Error_Lane3_phy" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_3_phy" description="The number error bits on lane 3." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_3_phy"></counter>
					<counter name="RX Kbits phy/Sec" symbol="RX_Kbits_phy_sec" uri="Mlx5.PortDiagnosticCounters.rx_kbits_phy_sec" description="Shows the rate at which the total amount of traffic could have been received." id="7" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_kbits_phy_sec"></counter>
					<counter name="RX PCS Symbol Error phy/Sec" symbol="RX_PCS_Symbol_Error_phy_sec" uri="Mlx5.PortDiagnosticCounters.rx_pcs_symbol_err_phy_sec" description="The rate of increasing of the number of symbol errors that wasn’t corrected by FEC  and that traffic was lost." id="8" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_pcs_symbol_err_phy_sec"></counter>
					<counter name="RX PCS Corrected Bits phy/Sec" symbol="RX_PCS_Corrected_Bits_phy_sec" uri="Mlx5.PortDiagnosticCounters.rx_pcs_corrected_bits_phy_sec" description="The rate of the number of corrected bits on this port according to active FEC (RS/FC)." id="9" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_pcs_corrected_bits_phy_sec"></counter>
					<counter name="RX Error Lane0 phy/Sec" symbol="RX_Error_Lane0_phy_sec" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_0_phy_sec" description="The rate of the number error bits on lane 0." id="10" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_0_phy_sec"></counter>
					<counter name="RX Error Lane1 phy/Sec" symbol="RX_Error_Lane1_phy_sec" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_1_phy_sec" description="The rate of the number error bits on lane 1." id="11" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_1_phy_sec"></counter>
					<counter name="RX Error Lane2 phy/Sec" symbol="RX_Error_Lane2_phy_sec" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_2_phy_sec" description="The rate of the number error bits on lane 2." id="12" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_2_phy_sec"></counter>
					<counter name="RX Error Lane3 phy/Sec" symbol="RX_Error_Lane3_phy_sec" uri="Mlx5.PortDiagnosticCounters.rx_err_lane_3_phy_sec" description="The rate of the number error bits on lane 3." id="13" type="perf_counter_bulk_count" detailLevel="standard" aggregate="sum" struct="PortDiagnosticCounterStruct" field="u64_rx_err_lane_3_phy_sec"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 VF Internal Traffic Counters" symbol="VfTrafficCounters" guid="{6a8f5462-5ca5-422a-b9d0-59096c9dd719}" uri="Mlx5.VfTrafficCounters" description="This set contains VF's internal traffic counters per ring" instances="multiple">
					<structs>
						<struct name="pVfTrafficCounters" type="vf_traffic_counters_v1"></struct>
					</structs>
					<counter name="Rx packets" uri="Mlx5.VfTrafficCounters.vf_traffic_counters_v1.RxPackets" description="Number of packets received" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="pVfTrafficCounters" field="RxPackets"></counter>
					<counter name="Rx octets" uri="Mlx5.VfTrafficCounters.vf_traffic_counters_v1.RxBytes" description="Number of bytes received" id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="pVfTrafficCounters" field="RxBytes"></counter>
					<counter name="Tx packets" uri="Mlx5.VfTrafficCounters.vf_traffic_counters_v1.TxPacket" description="Number of packets transmitted" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="pVfTrafficCounters" field="TxPackets"></counter>
					<counter name="Tx octets" uri="Mlx5.VfTrafficCounters.vf_traffic_counters_v1.TxBytes" description="Number of bytes transmitted" id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="pVfTrafficCounters" field="TxBytes"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOf-2 SW Backchannel Diagnostics" symbol="PfBackChannelDiagnosticCounters" guid="{3ed5f592-1923-4a84-ad9e-fd8e18534a18}" uri="Mlx5.PfBackChannelDiagnosticCounters" description="SR-IOV PF-VF Backchannel Communication Diagnostic. This set is intended mainly for Mellanox debug-ability, and advanced customers." instances="multiple">
					<structs>
						<struct name="PfBackChannelDiagnosticCountersStruct" type="PfBackChannelDiagCounters"></struct>
					</structs>
					<counter name="Supported Capabilities Bitmask" uri="Mlx5.PfBackChannelDiagCounters.SupportedCapabilitiesBitmask" description="Bitmask of capabilities supported by VF" id="0" type="perf_counter_large_rawcount_hex" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="SupportedCapabilitiesBitmask"></counter>
					<counter name="Currently Active Capabilities Bitmask" uri="Mlx5.PfBackChannelDiagCounters.CurrentlyActiveCapabilitiesBitmask" description="Bitmask of capabilities currently activated for VF" id="1" type="perf_counter_large_rawcount_hex" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="CurrentlyActiveCapabilitiesBitmask"></counter>
					<counter name="Read Config Block OIDs/Sec" uri="Mlx5.PfBackChannelDiagCounters.ReadConfigBlockOIDsSec" description="The number of OID_SRIOV_READ_VF_CONFIG_BLOCK received per second" id="2" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="ReadConfigBlockOIDsSec"></counter>
					<counter name="Write Config Block OIDs/Sec" uri="Mlx5.PfBackChannelDiagCounters.WriteConfigBlockOIDsSec" description="The number of OID_SRIOV_WRITE_VF_CONFIG_BLOCK received per second" id="3" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="WriteConfigBlockOIDsSec"></counter>
					<counter name="Illegal Or Unsupported Read Config Block OIDs" uri="Mlx5.PfBackChannelDiagCounters.IllegalUnsupportedReadConfigBlockOIDs" description="The number of OID_SRIOV_READ_VF_CONFIG_BLOCK detected as illegal or unsupported" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="IllegalUnsupportedReadConfigBlockOIDs"></counter>
					<counter name="Illegal Or Unsupported Write Config Block OIDs" uri="Mlx5.PfBackChannelDiagCounters.IllegalUnsupportedWriteConfigBlockOIDs" description="The number of OID_SRIOV_WRITE_VF_CONFIG_BLOCK detected as illegal or unsupported" id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="IllegalUnsupportedWriteConfigBlockOIDs"></counter>
					<counter name="Read Config Block OIDs Failed To Apply" uri="Mlx5.PfBackChannelDiagCounters.NonSuccessReadConfigBlockOIDs" description="The number of OID_SRIOV_READ_VF_CONFIG_BLOCK returned with fail status. Note: It does not necessary indicates error." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="NonSuccessReadConfigBlockOIDs"></counter>
					<counter name="Write Config Block OIDs Failed To Apply" uri="Mlx5.PfBackChannelDiagCounters.NonSuccessWriteConfigBlockOIDs" description="The number of OID_SRIOV_WRITE_VF_CONFIG_BLOCK returned with fail status. Note: It does not necessary indicates error." id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="undefined" struct="PfBackChannelDiagnosticCountersStruct" field="NonSuccessWriteConfigBlockOIDs"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 IB Port" symbol="IBPortCounters" guid="{626eea24-823f-478a-9c8d-b402207fb91d}" uri="Mlx5.IBPortCounters" description="This set contains IB port counters" instances="multipleAggregate">
					<structs>
						<struct name="IBPortCounterStruct" type="IBPortCounter"></struct>
					</structs>
					<counter name="Port Receive Data" symbol="Port_Receive_Data" uri="Mlx5.IBPortCounter.port_receive_data" description="The total number of data octets, divided by 4, (counting in double words, 32 bits), received on all VLs from the port." id="0" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortReceiveData"></counter>
					<counter name="Port Receive Packets" symbol="Port_Receive_Packets" uri="Mlx5.IBPortCounter.port_receive_packets" description="Total number of packets (this may include packets containing Errors. This is 64 bit counter." id="1" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortReceivePackets"></counter>
					<counter name="Port MultiCast Receive Packets" symbol="Port_MultiCast_Receive_Packets" uri="Mlx5.IBPortCounter.port_multicast_receive_packets" description="Total number of multicast packets, including multicast packets containing errors" id="2" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortMulticastReceivePackets"></counter>
					<counter name="Port Unicast Receive Packets" symbol="Port_Unicast_Receive_Packets" uri="Mlx5.IBPortCounter.port_unicast_receive_packets" description="Total number of unicast packets, including unicast packets containing errors." id="3" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortUnicastReceivePackets"></counter>
					<counter name="Port Xmit Data" symbol="Port_Xmit_Data" uri="Mlx5.IBPortCounter.port_xmit_data" description="The total number of data octets, divided by 4, (counting in double words, 32 bits), transmitted on all VLs from the port." id="4" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortXmitData"></counter>
					<counter name="Port Xmit Packets" symbol="Port_Xmit_Packets" uri="Mlx5.IBPortCounter.port_xmit_packets" description="Total number of packets transmitted on all VLs from this port. This may include packets with errors." id="5" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortXmitPackets"></counter>
					<counter name="Port Receive Switch Relay Errors" symbol="Port_Receive_Switch_Relay_Errors" uri="Mlx5.IBPortCounter.port_receive_switch_relay_errors" description="Total number of packets received on the port that were discarded because they could not be forwarded by the switch relay." id="6" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortReceiveSwitchRelayErrors"></counter>
					<counter name="Port Receive Errors" symbol="Port_Receive_Errors" uri="Mlx5.IBPortCounter.port_receive_errors" description="Total number of packets containing an error that were received on the port." id="7" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortReceiveErrors"></counter>
					<counter name="Port Receive Constraint Errors" symbol="Port_Receive_Constraint_Errors" uri="Mlx5.IBPortCounter.port_receive_constraint_errors" description="Total number of packets received on the switch physical port that are discarded." id="8" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortReceiveConstraintErrors"></counter>
					<counter name="Local Link Integrity Errors" symbol="Local_Link_Integrity_Errors" uri="Mlx5.IBPortCounter.local_link_integrity_errors" description="The number of times that the count of local physical errors exceeded the threshold specified by LocalPhyErrors." id="9" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="LocalLinkIntegrityErrors"></counter>
					<counter name="Port Xmit Wait" symbol="Port_Xmit_Wait" uri="Mlx5.IBPortCounter.port_xmit_wait" description="The number of ticks during which the port had data to transmit but no data was sent during the entire tick (either because of insufficient credits or because of lack of arbitration)." id="10" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortXmitWait"></counter>
					<counter name="Port MultiCast Xmit Packets" symbol="Port_MultiCast_Xmit_Packets" uri="Mlx5.IBPortCounter.port_multicast_xmit_packets" description="Total number of multicast packets transmitted on all VLs from the port. This may include multicast packets with errors." id="11" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortMulticastXmitPackets"></counter>
					<counter name="Port Unicast Xmit Packets" symbol="Port_Unicast_Xmit_Packets" uri="Mlx5.IBPortCounter.port_unicast_xmit_packets" description="Total number of unicast packets transmitted on all VLs from the port. This may include unicast packets with errors." id="12" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortUnicastXmitPackets"></counter>
					<counter name="Port Xmit Discards" symbol="Port_Xmit_Discards" uri="Mlx5.IBPortCounter.port_xmit_discards" description="Total number of outbound packets discarded by the port because the port is down or congested." id="13" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortXmitDiscards"></counter>
					<counter name="Port Xmit Constraint Errors" symbol="Port_Xmit_Constraint_Errors" uri="Mlx5.IBPortCounter.port_xmit_constraint_errors" description="Total number of packets not transmitted from the switch physical port." id="14" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortXmitConstraintErrors"></counter>
					<counter name="Port Receive Remote Physical Errors" symbol="Port_Receive_Remote_Physical_Errors" uri="Mlx5.IBPortCounter.port_receive_remote_physical_errors" description="Total number of packets marked with the EBP delimiter received on the port." id="15" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="PortReceiveRemotePhysicalErrors"></counter>
					<counter name="Symbol Error" symbol="Symbol_Error" uri="Mlx5.IBPortCounter.symbol_error" description="Total number of minor link errors detected on one or more physical lanes." id="16" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="SymbolError"></counter>
					<counter name="VL15 Dropped" symbol="VL15_Dropped" uri="Mlx5.IBPortCounter.VL15_dropped" description="Number of incoming VL15 packets dropped due to resource limitations (e.g., lack of buffers) of the port." id="17" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="VL15Dropped"></counter>
					<counter name="Link Error Recovery Counter" symbol="Link_Error_Recovery_Counter" uri="Mlx5.IBPortCounter.link_error_recovery_counter" description="Total number of times the Port Training state machine has successfully completed the link error recovery process." id="18" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="LinkErrorRecoveryCounter"></counter>
					<counter name="Link Downed" symbol="Link_Downed" uri="Mlx5.IBPortCounter.link_downed" description="Total number of times the Port Training state machine has failed the link error recovery process and downed the link." id="19" type="perf_counter_bulk_count" detailLevel="standard" aggregate="undefined" struct="IBPortCounterStruct" field="LinkDowned"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 ICMC Diag Counters Ext1" symbol="ICMCDiagnosticCountersExt1" guid="{26317ade-e962-4fc2-b27e-faa4823b2fe3}" uri="Mlx5.ICMCDiagCountersExt1" description="This set contains interconnect contexts memory cache diagnostic counters" instances="multipleAggregate">
					<structs>
						<struct name="ICMCDiagnosticCountersExt1Struct" type="ICMCDiagCounterExt1"></struct>
					</structs>
					<counter name="ICMC QP Send Hit" uri="Mlx5.IcmcCounter1.ICMC_QP_S_HIT" description="Internal cache hits for Send Queue Pair contexts" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uQpSHit"></counter>
					<counter name="ICMC QP Send Miss" uri="Mlx5.IcmcCounter1.ICMC_QP_S_MISS" description="Internal cache misses for Send Queue Pair contexts" id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uQpSMiss"></counter>
					<counter name="ICMC QP Receive Hit" uri="Mlx5.IcmcCounter1.ICMC_QP_R_HIT" description="Internal cache hits for Receive Queue Pair contexts" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uQpRHit"></counter>
					<counter name="ICMC QP Receive Miss" uri="Mlx5.IcmcCounter1.ICMC_QP_R_MISS" description="Internal cache misses for Receive Queue Pair contexts" id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uQpRMiss"></counter>
					<counter name="ICMC SRQ Hit" uri="Mlx5.IcmcCounter1.ICMC_SRQ_HIT" description="Internal cache hits for Shared Receive Queue contexts" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uSrqHit"></counter>
					<counter name="ICMC SRQ Miss" uri="Mlx5.IcmcCounter1.ICMC_SRQ_MISS" description="Internal cache misses for Shared Receive Queue contexts" id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uSrqMiss"></counter>
					<counter name="ICMC CQ Hit" uri="Mlx5.IcmcCounter1.ICMC_CQ_HIT" description="Internal cache hits for Completion Queue contexts" id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uCqHit"></counter>
					<counter name="ICMC CQ Miss" uri="Mlx5.IcmcCounter1.ICMC_CQ_MISS" description="Internal cache misses for Completion Queue contexts" id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="ICMCDiagnosticCountersExt1Struct" field="uCqMiss"></counter>
				</counterSet>
			</provider>
		</counters>
	</instrumentation>
</instrumentationManifest>
